/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.plugins.job.JobParametersBean;

public class ModuleJobLauncher
implements Lifecycle {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private JobLauncher launcher;
    private String groupName;
    private JobRegistry registry;
    private static String JOB_NAME_DELIMITER = ".";
    private static int NAME_INDEX = 0;
    private boolean isRunning = false;
    private final boolean executeBatchJobOnStartup;
    private final JobParameters jobParameters;

    public ModuleJobLauncher(JobLauncher launcher, JobRegistry registry, boolean executeBatchJobOnStartup, JobParametersBean jobParametersBean) {
        Assert.notNull((Object)launcher, (String)"A JobLauncher is required");
        this.launcher = launcher;
        this.registry = registry;
        this.executeBatchJobOnStartup = executeBatchJobOnStartup;
        this.jobParameters = jobParametersBean.getJobParameters();
    }

    public void start() {
        this.isRunning = true;
        if (this.executeBatchJobOnStartup) {
            this.executeBatchJob();
        }
    }

    public void executeBatchJob() {
        Collection names = this.registry.getJobNames();
        for (String curName : names) {
            String[] jobNames = StringUtils.split((String)curName, (String)JOB_NAME_DELIMITER);
            if (!jobNames[NAME_INDEX].equals(this.groupName)) continue;
            try {
                this.launcher.run(this.registry.getJob(curName), this.jobParameters);
            }
            catch (Exception e) {
                this.logger.error("An error occured while starting job " + curName, (Throwable)e);
            }
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }
}

