/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.validation.constraints.AssertTrue;
import org.springframework.xd.dirt.plugins.job.support.listener.XDJobListenerConstants;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;
import org.springframework.xd.module.options.PojoModuleOptionsMetadata;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

public class JobPluginMetadataResolver
implements ModuleOptionsMetadataResolver {
    public ModuleOptionsMetadata resolve(ModuleDefinition moduleDefinition) {
        if (moduleDefinition.getType() == ModuleType.job) {
            return new PojoModuleOptionsMetadata(JobOptionsMetadata.class);
        }
        return null;
    }

    public static class JobOptionsMetadata
    implements ProfileNamesProvider {
        private boolean makeUnique = true;
        private String numberFormat = "";
        private String dateFormat = "yyyy-MM-dd";
        private String listeners = "";
        private String DISABLE_OPTION = "disable";
        private final List<String> VALID_LISTENER_SUFFIXES = new ArrayList<String>(Arrays.asList(XDJobListenerConstants.XD_JOB_LISTENERS_SUFFIXES));
        private Collection<String> listenerProfilesToAdd = new ArrayList<String>();
        private static final Map<String, String> XD_JOB_LISTENER_PROFILES = new HashMap<String, String>();

        public boolean isMakeUnique() {
            return this.makeUnique;
        }

        public String getNumberFormat() {
            return this.numberFormat;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public String getListeners() {
            return this.listeners;
        }

        @ModuleOption(value="whether always allow re-invocation of this job")
        public void setMakeUnique(boolean makeUnique) {
            this.makeUnique = makeUnique;
        }

        @ModuleOption(value="the number format to use when parsing numeric parameters")
        public void setNumberFormat(String numberFormat) {
            this.numberFormat = numberFormat;
        }

        @ModuleOption(value="the date format to use when parsing date parameters")
        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @AssertTrue(message="must be 'disable' or a combination of [job,step,chunk,item and skip]")
        public boolean isListenersListValid() {
            ArrayList<String> validOptions = new ArrayList<String>(this.VALID_LISTENER_SUFFIXES);
            validOptions.add(this.DISABLE_OPTION);
            StringTokenizer tokenizer = new StringTokenizer(this.listeners, ",");
            while (tokenizer.hasMoreElements()) {
                String optionName = (String)tokenizer.nextElement();
                if (validOptions.contains(optionName)) continue;
                return false;
            }
            return true;
        }

        @ModuleOption(value="listeners from [job,step,chunk,item,skip] as csv or 'disable' (default enables all)")
        public void setListeners(String listeners) {
            this.listeners = listeners;
        }

        public String[] profilesToActivate() {
            if (this.listeners.contains(this.DISABLE_OPTION)) {
                return NO_PROFILES;
            }
            StringTokenizer tokenizer = new StringTokenizer(this.listeners, ",");
            while (tokenizer.hasMoreElements()) {
                String suffixName = (String)tokenizer.nextElement();
                this.listenerProfilesToAdd.add(XD_JOB_LISTENER_PROFILES.get(suffixName));
            }
            if (this.listenerProfilesToAdd.isEmpty()) {
                this.listenerProfilesToAdd.addAll(XD_JOB_LISTENER_PROFILES.values());
            }
            return this.listenerProfilesToAdd.toArray(new String[this.listenerProfilesToAdd.size()]);
        }

        static {
            XD_JOB_LISTENER_PROFILES.put("job", "xd.jobExecutionListener");
            XD_JOB_LISTENER_PROFILES.put("step", "xd.stepExecutionListener");
            XD_JOB_LISTENER_PROFILES.put("chunk", "xd.chunkListener");
            XD_JOB_LISTENER_PROFILES.put("item", "xd.itemListener");
            XD_JOB_LISTENER_PROFILES.put("skip", "xd.skipListener");
        }
    }
}

