/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.plugins.AbstractJobPlugin;
import org.springframework.xd.module.core.Module;

public class JobPlugin
extends AbstractJobPlugin {
    private static final String REGISTRAR = "META-INF/spring-xd/plugins/job/job-module-beans.xml";
    public static final String JOB_PARAMETERS_KEY = "jobParameters";

    public JobPlugin(MessageBus messageBus) {
        super(messageBus);
    }

    private void configureProperties(Module module) {
        Properties properties = new Properties();
        properties.setProperty("xd.job.name", module.getDescriptor().getGroup());
        module.addProperties(properties);
    }

    @Override
    public void preProcessModule(Module module) {
        Assert.notNull((Object)module, (String)"module cannot be null");
        module.addSource((Object)new ClassPathResource(REGISTRAR));
        this.configureProperties(module);
    }

    @Override
    public void postProcessModule(Module module) {
        this.bindConsumerAndProducers(module);
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

