/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.Properties;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.BusUtils;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.plugins.AbstractJobPlugin;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.core.Module;

public class JobPartitionerPlugin
extends AbstractJobPlugin {
    private static final String JOB_PARTIONER_REQUEST_CHANNEL = "stepExecutionRequests.output";
    private static final String JOB_PARTIONER_REPLY_CHANNEL = "stepExecutionReplies.input";
    private static final String JOB_STEP_EXECUTION_REQUEST_CHANNEL = "stepExecutionRequests.input";
    private static final String JOB_STEP_EXECUTION_REPLY_CHANNEL = "stepExecutionReplies.output";

    public JobPartitionerPlugin(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    public void postProcessModule(Module module) {
        if (this.messageBus != null && module.getComponent(JOB_PARTIONER_REQUEST_CHANNEL, MessageChannel.class) != null) {
            this.processPartitionedJob(module);
        }
    }

    private void processPartitionedJob(Module module) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("binding job partitioning channels for " + module);
        }
        Properties[] properties = this.extractConsumerProducerProperties(module);
        MessageChannel partitionsOut = (MessageChannel)module.getComponent(JOB_PARTIONER_REQUEST_CHANNEL, MessageChannel.class);
        Assert.notNull((Object)partitionsOut, (String)"Partitioned jobs must have a stepExecutionRequests.output");
        MessageChannel partitionsIn = (MessageChannel)module.getComponent(JOB_PARTIONER_REPLY_CHANNEL, MessageChannel.class);
        Assert.notNull((Object)partitionsIn, (String)"Partitioned jobs must have a stepExecutionReplies.input");
        ModuleDescriptor descriptor = module.getDescriptor();
        String name = JobPartitionerPlugin.getJobChannelName(BusUtils.constructPipeName((String)descriptor.getGroup(), (int)descriptor.getIndex()));
        this.messageBus.bindRequestor(name, partitionsOut, partitionsIn, properties[0]);
        MessageChannel stepExecutionsIn = (MessageChannel)module.getComponent(JOB_STEP_EXECUTION_REQUEST_CHANNEL, MessageChannel.class);
        Assert.notNull((Object)stepExecutionsIn, (String)"Partitioned jobs must have a stepExecutionRequests.input");
        MessageChannel stepExecutionResultsOut = (MessageChannel)module.getComponent(JOB_STEP_EXECUTION_REPLY_CHANNEL, MessageChannel.class);
        Assert.notNull((Object)stepExecutionResultsOut, (String)"Partitioned jobs must have a stepExecutionReplies.output");
        this.messageBus.bindReplier(name, stepExecutionsIn, stepExecutionResultsOut, properties[0]);
    }

    private void unbindPartitionedJob(Module module) {
        MessageChannel stepExecutionResultsOut;
        MessageChannel stepExcutionsIn;
        MessageChannel partitionsIn;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unbinding job partitioning channels for " + module);
        }
        MessageChannel partitionsOut = (MessageChannel)module.getComponent(JOB_PARTIONER_REQUEST_CHANNEL, MessageChannel.class);
        ModuleDescriptor descriptor = module.getDescriptor();
        String name = JobPartitionerPlugin.getJobChannelName(BusUtils.constructPipeName((String)descriptor.getGroup(), (int)descriptor.getIndex()));
        if (partitionsOut != null) {
            this.messageBus.unbindProducer(name, partitionsOut);
        }
        if ((partitionsIn = (MessageChannel)module.getComponent(JOB_PARTIONER_REPLY_CHANNEL, MessageChannel.class)) != null) {
            this.messageBus.unbindConsumer(name, partitionsIn);
        }
        if ((stepExcutionsIn = (MessageChannel)module.getComponent(JOB_STEP_EXECUTION_REQUEST_CHANNEL, MessageChannel.class)) != null) {
            this.messageBus.unbindConsumer(name, stepExcutionsIn);
        }
        if ((stepExecutionResultsOut = (MessageChannel)module.getComponent(JOB_STEP_EXECUTION_REPLY_CHANNEL, MessageChannel.class)) != null) {
            this.messageBus.unbindProducer(name, stepExecutionResultsOut);
        }
    }

    @Override
    public void beforeShutdown(Module module) {
    }

    @Override
    public void removeModule(Module module) {
        if (module.getComponent(JOB_PARTIONER_REQUEST_CHANNEL, MessageChannel.class) != null) {
            this.unbindPartitionedJob(module);
        }
    }
}

