/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.integration.annotation.Transformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.plugins.job.ExpandedJobParametersConverter;
import org.springframework.xd.tuple.Tuple;

public class JobLaunchRequestTransformer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobRegistry jobRegistry;
    private final String jobName;
    private volatile ExpandedJobParametersConverter jobParametersConverter = new ExpandedJobParametersConverter();

    public JobLaunchRequestTransformer(JobRegistry jobRegistry, String jobName) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        this.jobRegistry = jobRegistry;
        this.jobName = jobName;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.jobParametersConverter.setDateFormat(dateFormat);
    }

    public void setDateFormatAsString(String dateFormat) {
        this.jobParametersConverter.setDateFormatAsString(dateFormat);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.jobParametersConverter.setNumberFormat(numberFormat);
    }

    public void setNumberFormatAsString(String numberFormat) {
        this.jobParametersConverter.setNumberFormatAsString(numberFormat);
    }

    public void setMakeParametersUnique(boolean makeParametersUnique) {
        this.jobParametersConverter.setMakeParametersUnique(makeParametersUnique);
    }

    @Transformer
    public JobLaunchRequest toJobLaunchRequest(Message<?> message) {
        JobParameters jobParameters;
        Job job;
        try {
            job = this.jobRegistry.getJob(this.jobName);
        }
        catch (NoSuchJobException e) {
            throw new IllegalArgumentException("The job " + this.jobName + " doesn't exist. Is it deployed?");
        }
        Object payload = message.getPayload();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("JobParameters are provided as '%s'. Convertering to Spring Batch JobParameters...", payload.getClass().getSimpleName()));
        }
        if (payload instanceof File) {
            jobParameters = this.jobParametersConverter.getJobParametersForFile((File)message.getPayload());
        } else if (payload instanceof String) {
            jobParameters = this.jobParametersConverter.getJobParametersForJsonString((String)payload);
        } else if (payload instanceof Properties) {
            jobParameters = this.jobParametersConverter.getJobParameters((Properties)payload);
        } else if (payload instanceof Map) {
            jobParameters = this.jobParametersConverter.getJobParametersForMap((Map)payload);
        } else if (payload instanceof Tuple) {
            Tuple tuple = (Tuple)payload;
            List tupleValues = tuple.getValues();
            LinkedHashMap map = new LinkedHashMap(tupleValues.size());
            for (int i = 0; i < tupleValues.size(); ++i) {
                map.put(tuple.getFieldNames().get(i), tupleValues.get(i));
            }
            jobParameters = this.jobParametersConverter.getJobParametersForMap(map);
        } else {
            throw new IllegalArgumentException("This transformer does not support payloads of type " + payload.getClass().getSimpleName());
        }
        boolean isRestart = Boolean.valueOf(jobParameters.getString("XD_isRestart"));
        if (job.getJobParametersIncrementer() != null && !isRestart) {
            jobParameters = job.getJobParametersIncrementer().getNext(jobParameters);
        }
        jobParameters = this.jobParametersConverter.removeRestartParameterIfExists(jobParameters);
        return new JobLaunchRequest(job, jobParameters);
    }
}

