/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.plugins.AbstractJobPlugin;
import org.springframework.xd.dirt.plugins.job.support.listener.XDJobListenerConstants;
import org.springframework.xd.module.core.Module;

public class JobEventsListenerPlugin
extends AbstractJobPlugin
implements XDJobListenerConstants {
    private static final String JOB_TAP_CHANNEL_PREFIX = "tap:job:";

    public JobEventsListenerPlugin(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    public void postProcessModule(Module module) {
        boolean disableListeners = true;
        Map<String, String> eventChannels = JobEventsListenerPlugin.getEventListenerChannels(module.getDescriptor().getGroup());
        for (Map.Entry<String, String> entry : eventChannels.entrySet()) {
            MessageChannel eventChannel = (MessageChannel)module.getComponent(entry.getKey(), SubscribableChannel.class);
            if (eventChannel == null) continue;
            this.messageBus.bindPubSubProducer(entry.getValue(), eventChannel, null);
            disableListeners = false;
        }
        if (!disableListeners) {
            this.bindAggregatedEventsChannel(module);
        }
    }

    public static Map<String, String> getEventListenerChannels(String jobName) {
        HashMap<String, String> eventListenerChannels = new HashMap<String, String>();
        Assert.notNull((Object)jobName, (String)"Job name should not be null");
        eventListenerChannels.put("xd.job.jobExecutionEvents", JobEventsListenerPlugin.getEventListenerChannelName(jobName, "job"));
        eventListenerChannels.put("xd.job.stepExecutionEvents", JobEventsListenerPlugin.getEventListenerChannelName(jobName, "step"));
        eventListenerChannels.put("xd.job.chunkEvents", JobEventsListenerPlugin.getEventListenerChannelName(jobName, "chunk"));
        eventListenerChannels.put("xd.job.itemEvents", JobEventsListenerPlugin.getEventListenerChannelName(jobName, "item"));
        eventListenerChannels.put("xd.job.skipEvents", JobEventsListenerPlugin.getEventListenerChannelName(jobName, "skip"));
        return eventListenerChannels;
    }

    private static String getEventListenerChannelName(String jobName, String channelNameSuffix) {
        return String.format("%s%s.%s", JOB_TAP_CHANNEL_PREFIX, jobName, channelNameSuffix);
    }

    public static String getEventListenerChannelName(String jobName) {
        return String.format("%s%s", JOB_TAP_CHANNEL_PREFIX, jobName);
    }

    private void bindAggregatedEventsChannel(Module module) {
        String jobName = module.getDescriptor().getGroup();
        MessageChannel aggEventsChannel = (MessageChannel)module.getComponent("xd.job.aggregatedEvents", SubscribableChannel.class);
        Assert.notNull((Object)aggEventsChannel, (String)"The pub/sub aggregatedEvents channel should be available in the module context.");
        this.messageBus.bindPubSubProducer(JobEventsListenerPlugin.getEventListenerChannelName(jobName), aggEventsChannel, null);
    }

    @Override
    public void removeModule(Module module) {
        Map<String, String> eventListenerChannels = JobEventsListenerPlugin.getEventListenerChannels(module.getDescriptor().getGroup());
        for (Map.Entry<String, String> channelEntry : eventListenerChannels.entrySet()) {
            this.messageBus.unbindProducers(channelEntry.getValue());
        }
        this.messageBus.unbindProducers(JobEventsListenerPlugin.getEventListenerChannelName(module.getDescriptor().getGroup()));
    }
}

