/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.rest.domain.util.TimeUtils;

public class ExpandedJobParametersConverter
extends DefaultJobParametersConverter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String ABSOLUTE_FILE_PATH = "absoluteFilePath";
    public static final String UNIQUE_JOB_PARAMETER_KEY = "random";
    public static final String IS_RESTART_JOB_PARAMETER_KEY = "XD_isRestart";
    private volatile boolean makeParametersUnique = true;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ExpandedJobParametersConverter() {
        this.setDateFormat(TimeUtils.getDefaultDateFormat());
    }

    public void setDateFormat(DateFormat dateFormat) {
        Assert.notNull((Object)dateFormat, (String)"The provided dateFormat must not be null.");
        super.setDateFormat(dateFormat);
    }

    public void setDateFormatAsString(String dateFormatAsString) {
        if (StringUtils.hasText((String)dateFormatAsString)) {
            super.setDateFormat((DateFormat)new SimpleDateFormat(dateFormatAsString));
        }
    }

    public void setMakeParametersUnique(boolean makeParametersUnique) {
        this.makeParametersUnique = makeParametersUnique;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        Assert.notNull((Object)numberFormat, (String)"The provided numberFormat must not be null.");
        super.setNumberFormat(numberFormat);
    }

    public void setNumberFormatAsString(String numberFormatAsString) {
        if (StringUtils.hasText((String)numberFormatAsString)) {
            super.setNumberFormat((NumberFormat)new DecimalFormat(numberFormatAsString));
        }
    }

    public JobParameters getJobParametersForFile(File file) {
        Assert.notNull((Object)file, (String)"The provided file must not be null.");
        Properties parametersAsProperties = new Properties();
        parametersAsProperties.put(ABSOLUTE_FILE_PATH, file.getAbsolutePath());
        return this.getJobParameters(parametersAsProperties);
    }

    public JobParameters getJobParametersForJsonString(String jobParametersAsJsonMap) {
        Map parameters;
        if (jobParametersAsJsonMap != null && !jobParametersAsJsonMap.isEmpty()) {
            MapType mapType = this.objectMapper.getTypeFactory().constructMapType(HashMap.class, String.class, String.class);
            try {
                parameters = (Map)new ObjectMapper().readValue(jobParametersAsJsonMap, (JavaType)mapType);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to convert provided JSON to Map<String, Object>", e);
            }
        } else {
            parameters = null;
        }
        return this.getJobParametersForMap(parameters);
    }

    public JobParameters getJobParametersForMap(Map<?, ?> map) {
        Properties parametersAsProperties = new Properties();
        if (map != null) {
            parametersAsProperties.putAll(map);
        }
        return this.getJobParameters(parametersAsProperties);
    }

    public JobParameters getJobParameters(Properties properties) {
        Properties localProperties = properties != null ? properties : new Properties();
        boolean isRestart = localProperties.containsKey(IS_RESTART_JOB_PARAMETER_KEY) ? Boolean.valueOf(localProperties.getProperty(IS_RESTART_JOB_PARAMETER_KEY)) : false;
        if (this.makeParametersUnique && !isRestart) {
            if (localProperties.containsKey(UNIQUE_JOB_PARAMETER_KEY)) {
                throw new IllegalStateException(String.format("Parameter '%s' is already used to identify uniqueness for the executing Batch job.", UNIQUE_JOB_PARAMETER_KEY));
            }
            localProperties.put(UNIQUE_JOB_PARAMETER_KEY, String.valueOf(Math.random()));
        }
        return super.getJobParameters(localProperties);
    }

    public String getJobParametersAsString(JobParameters jobParameters) {
        return this.getJobParametersAsString(jobParameters, false);
    }

    public String getJobParametersAsString(JobParameters jobParameters, boolean isRestart) {
        String jobParametersAsString;
        Assert.notNull((Object)jobParameters, (String)"jobParameters must not be null.");
        Properties properties = this.getProperties(jobParameters);
        if (isRestart) {
            properties.put(IS_RESTART_JOB_PARAMETER_KEY, Boolean.TRUE.toString());
        }
        TreeMap<Object, Object> sortedJobParameters = new TreeMap<Object, Object>(properties);
        try {
            jobParametersAsString = new ObjectMapper().writeValueAsString(sortedJobParameters);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to convert provided job parameters to JSON String.", e);
        }
        return jobParametersAsString;
    }

    public JobParameters removeRestartParameterIfExists(JobParameters jobParameters) {
        Assert.notNull((Object)jobParameters, (String)"'jobParameters' must not be null.");
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        for (Map.Entry entry : jobParameters.getParameters().entrySet()) {
            if (IS_RESTART_JOB_PARAMETER_KEY.equalsIgnoreCase((String)entry.getKey())) continue;
            jobParametersBuilder.addParameter((String)entry.getKey(), (JobParameter)entry.getValue());
        }
        return jobParametersBuilder.toJobParameters();
    }
}

