/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.Collection;
import org.springframework.batch.admin.service.SearchableJobExecutionDao;
import org.springframework.batch.admin.service.SearchableJobInstanceDao;
import org.springframework.batch.admin.service.SearchableStepExecutionDao;
import org.springframework.batch.admin.service.SimpleJobService;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.xd.dirt.job.dao.XdJdbcSearchableJobExecutionDao;
import org.springframework.xd.dirt.plugins.job.DistributedJobLocator;

public class DistributedJobService
extends SimpleJobService {
    private DistributedJobLocator distributedJobLocator;
    private XdJdbcSearchableJobExecutionDao xdJdbcSearchableJobExecutionDao;

    public DistributedJobService(SearchableJobInstanceDao jobInstanceDao, XdJdbcSearchableJobExecutionDao xdJdbcSearchableJobExecutionDao, SearchableStepExecutionDao stepExecutionDao, JobRepository jobRepository, JobLauncher jobLauncher, DistributedJobLocator batchJobLocator, ExecutionContextDao executionContextDao) {
        super(jobInstanceDao, (SearchableJobExecutionDao)xdJdbcSearchableJobExecutionDao, stepExecutionDao, jobRepository, jobLauncher, (ListableJobLocator)batchJobLocator, executionContextDao);
        this.distributedJobLocator = batchJobLocator;
        this.xdJdbcSearchableJobExecutionDao = xdJdbcSearchableJobExecutionDao;
    }

    public JobExecution launch(String jobName, JobParameters params) throws NoSuchJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        throw new UnsupportedOperationException("Job Launch");
    }

    public JobExecution restart(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, NoSuchJobException, JobParametersInvalidException {
        throw new UnsupportedOperationException("Restart");
    }

    public JobExecution abandon(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException {
        throw new UnsupportedOperationException("Abandon");
    }

    public boolean isIncrementable(String jobName) {
        return this.isLaunchable(jobName) ? this.distributedJobLocator.isIncrementable(jobName) : false;
    }

    public Job getJob(String jobName) throws NoSuchJobException {
        return this.distributedJobLocator.getJob(jobName);
    }

    public Collection<JobExecution> getTopLevelJobExecutions(int start, int count) {
        return this.xdJdbcSearchableJobExecutionDao.getTopLevelJobExecutions(start, count);
    }

    public int countTopLevelJobExecutions() {
        return this.xdJdbcSearchableJobExecutionDao.countTopLevelJobExecutions();
    }

    public Collection<JobExecution> getChildJobExecutions(long jobExecutionId) {
        return this.xdJdbcSearchableJobExecutionDao.getChildJobExecutions(jobExecutionId);
    }

    public boolean isComposedJobExecution(long jobExecutionId) {
        return this.xdJdbcSearchableJobExecutionDao.isComposedJobExecution(jobExecutionId);
    }
}

