/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class DistributedJobLocator
implements ListableJobLocator {
    private static final String GET_ALL_JOB_NAMES = "SELECT JOB_NAME FROM XD_JOB_REGISTRY";
    private static final String GET_ALL_RESTARTABLE_JOBS = "SELECT JOB_NAME FROM XD_JOB_REGISTRY WHERE IS_RESTARTABLE='true'";
    private static final String JOB_INCREMENTABLE = "SELECT IS_INCREMENTABLE FROM XD_JOB_REGISTRY WHERE JOB_NAME = ?";
    private static final String JOB_RESTARTABLE = "SELECT IS_RESTARTABLE FROM XD_JOB_REGISTRY WHERE JOB_NAME = ?";
    private static final String GET_STEP_NAMES = "SELECT STEP_NAME FROM XD_JOB_REGISTRY_STEP_NAMES WHERE JOB_NAME = ?";
    private static final String ADD_JOB_REGISTRY = "INSERT INTO XD_JOB_REGISTRY(IS_INCREMENTABLE, IS_RESTARTABLE, JOB_NAME) VALUES(?, ?, ?)";
    private static final String ADD_STEP_NAME = "INSERT INTO XD_JOB_REGISTRY_STEP_NAMES(JOB_NAME, STEP_NAME) VALUES(?, ?)";
    private static final String UPDATE_JOB_REGISTRY = "UPDATE XD_JOB_REGISTRY SET IS_INCREMENTABLE = ?, IS_RESTARTABLE = ? WHERE JOB_NAME = ?";
    private static final String DELETE_JOB_REGISTRY = "DELETE FROM XD_JOB_REGISTRY WHERE JOB_NAME = ?";
    private static final String DELETE_STEP_NAMES = "DELETE FROM XD_JOB_REGISTRY_STEP_NAMES WHERE JOB_NAME = ?";
    private static final String DELETE_ALL_JOB_REGISTRY = "DELETE FROM XD_JOB_REGISTRY";
    private static final String DELETE_ALL_STEP_NAMES = "DELETE FROM XD_JOB_REGISTRY_STEP_NAMES";
    private JdbcOperations jdbcTemplate;

    public Collection<String> getJobNames() {
        return this.jdbcTemplate.queryForList(GET_ALL_JOB_NAMES, String.class);
    }

    public Collection<String> getAllRestartableJobs() {
        return this.jdbcTemplate.queryForList(GET_ALL_RESTARTABLE_JOBS, String.class);
    }

    public Job getJob(final String name) throws NoSuchJobException {
        if (!this.getJobNames().contains(name)) {
            throw new NoSuchJobException(name);
        }
        SimpleJob job = new SimpleJob(name){

            public Collection<String> getStepNames() {
                return DistributedJobLocator.this.getJobStepNames(name);
            }
        };
        return job;
    }

    public List<String> getJobStepNames(String jobName) {
        return this.jdbcTemplate.query(GET_STEP_NAMES, (RowMapper)new SingleColumnRowMapper(String.class), new Object[]{jobName});
    }

    protected void addJob(String name, boolean incrementable, boolean restartable) {
        Collection<String> jobNames = this.getJobNames();
        if (!jobNames.contains(name)) {
            this.addJobName(name, incrementable, restartable);
        } else {
            this.updateJobName(name, incrementable, restartable);
        }
    }

    private void addJobName(String name, boolean incrementable, boolean restartable) {
        this.jdbcTemplate.update(ADD_JOB_REGISTRY, new Object[]{incrementable, restartable, name});
    }

    private void updateJobName(String name, boolean incrementable, boolean restartable) {
        this.jdbcTemplate.update(UPDATE_JOB_REGISTRY, new Object[]{incrementable, restartable, name});
    }

    protected void addStepNames(String jobName, Collection<String> stepNames) {
        for (String stepName : stepNames) {
            this.jdbcTemplate.update(ADD_STEP_NAME, new Object[]{jobName, stepName});
        }
    }

    protected void deleteJobRegistry(String jobName) {
        this.jdbcTemplate.update(DELETE_JOB_REGISTRY, new Object[]{jobName});
        this.jdbcTemplate.update(DELETE_STEP_NAMES, new Object[]{jobName});
    }

    protected void deleteAll() {
        this.jdbcTemplate.update(DELETE_ALL_JOB_REGISTRY);
        this.jdbcTemplate.update(DELETE_ALL_STEP_NAMES);
    }

    public Boolean isIncrementable(String jobName) {
        return (Boolean)this.jdbcTemplate.queryForObject(JOB_INCREMENTABLE, Boolean.class, new Object[]{jobName});
    }

    public Boolean isRestartable(String jobName) {
        return (Boolean)this.jdbcTemplate.queryForObject(JOB_RESTARTABLE, Boolean.class, new Object[]{jobName});
    }

    public JdbcOperations getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

