/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins.job;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.JobRegistryBeanPostProcessor;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.plugins.job.BatchJobAlreadyExistsInRegistryException;
import org.springframework.xd.dirt.plugins.job.DistributedJobLocator;
import org.springframework.xd.dirt.plugins.job.support.listener.XDJobListenerConstants;

public class BatchJobRegistryBeanPostProcessor
extends JobRegistryBeanPostProcessor
implements BeanFactoryAware,
XDJobListenerConstants {
    private static final Logger logger = LoggerFactory.getLogger(BatchJobRegistryBeanPostProcessor.class);
    public static final String JOB = "job";
    private JobRegistry jobRegistry;
    private DefaultListableBeanFactory beanFactory;
    private DistributedJobLocator jobLocator;
    private String groupName;
    private List<JobExecutionListener> jobExecutionListeners = new ArrayList<JobExecutionListener>();
    private List<StepListener> stepListeners = new ArrayList<StepListener>();

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
        super.setJobRegistry(jobRegistry);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            this.beanFactory = (DefaultListableBeanFactory)beanFactory;
        }
        super.setBeanFactory(beanFactory);
    }

    public void setJobLocator(DistributedJobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof StepParserStepFactoryBean) {
            this.addStepListeners();
            if (!this.stepListeners.isEmpty()) {
                ((StepParserStepFactoryBean)bean).setListeners((Object[])this.stepListeners.toArray(new StepListener[this.stepListeners.size()]));
            }
        } else if (bean instanceof Job) {
            if (!this.jobRegistry.getJobNames().contains(this.groupName)) {
                String[] beansOfType = this.beanFactory.getBeanNamesForType(Job.class);
                if (beansOfType.length > 1) {
                    if (beanName.equalsIgnoreCase(JOB)) {
                        this.postProcessJob(bean, beanName);
                    } else {
                        logger.debug(beanName + " was not registered as a job since the context has more than one job " + "defined and it's id is not 'job'");
                    }
                } else {
                    this.postProcessJob(bean, beanName);
                }
            } else if (this.jobRegistry.getJobNames().contains(this.groupName)) {
                throw new BatchJobAlreadyExistsInRegistryException(this.groupName);
            }
        }
        return bean;
    }

    private void postProcessJob(Object bean, String beanName) {
        AbstractJob job = (AbstractJob)bean;
        job.setName(this.groupName);
        this.addJobExecutionListener();
        if (!this.jobExecutionListeners.isEmpty()) {
            job.setJobExecutionListeners(this.jobExecutionListeners.toArray(new JobExecutionListener[this.jobExecutionListeners.size()]));
        }
        this.jobLocator.addJob(this.groupName, job.getJobParametersIncrementer() != null, job.isRestartable());
        this.jobLocator.addStepNames(this.groupName, job.getStepNames());
        super.postProcessAfterInitialization(bean, beanName);
    }

    private void addJobExecutionListener() {
        Map listeners = this.beanFactory.getBeansOfType(JobExecutionListener.class);
        this.jobExecutionListeners.addAll(listeners.values());
    }

    private void addStepListeners() {
        if (this.beanFactory.containsBean("xd.stepExecutionListener")) {
            this.stepListeners.add((StepListener)this.beanFactory.getBean("xd.stepExecutionListener"));
        }
        if (this.beanFactory.containsBean("xd.chunkListener")) {
            this.stepListeners.add((StepListener)this.beanFactory.getBean("xd.chunkListener"));
        }
        if (this.beanFactory.containsBean("xd.itemListener")) {
            this.stepListeners.add((StepListener)this.beanFactory.getBean("xd.itemListener"));
        }
        if (this.beanFactory.containsBean("xd.skipListener")) {
            this.stepListeners.add((StepListener)this.beanFactory.getBean("xd.skipListener"));
        }
    }

    public void destroy() throws Exception {
        Assert.notNull((Object)this.groupName, (String)"JobName should not be null");
        this.jobLocator.deleteJobRegistry(this.groupName);
        super.destroy();
    }
}

