/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins;

import java.util.List;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.xd.dirt.DirtException;
import org.springframework.xd.module.ModuleType;

public class ModuleConfigurationException
extends DirtException {
    public ModuleConfigurationException(String message) {
        super(message);
    }

    public ModuleConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

    public static ModuleConfigurationException fromBindException(String name, ModuleType type, BindException e) {
        StringBuilder sb = new StringBuilder("Error with option(s) for module ");
        sb.append(name).append(" of type ").append(type.name()).append(":");
        List errors = e.getBindingResult().getFieldErrors();
        for (FieldError error : errors) {
            sb.append("\n    ").append(error.getField()).append(": ").append(error.getDefaultMessage());
        }
        ModuleConfigurationException result = new ModuleConfigurationException(sb.toString(), (Throwable)e);
        return result;
    }
}

