/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.xd.dirt.plugins.AbstractPlugin;
import org.springframework.xd.module.core.Module;

public class MBeanExportingPlugin
extends AbstractPlugin {
    private static final String CONTEXT_CONFIG_ROOT = "META-INF/spring-xd/plugins/jmx/";
    @Value(value="${XD_JMX_ENABLED}")
    private boolean jmxEnabled;

    @Override
    public void preProcessModule(Module module) {
        Properties properties = new Properties();
        properties.setProperty("xd.group.name", module.getDescriptor().getGroup());
        module.addProperties(properties);
        module.addSource((Object)new ClassPathResource("META-INF/spring-xd/plugins/jmx/mbean-exporters.xml"));
    }

    @Override
    public boolean supports(Module module) {
        return this.jmxEnabled;
    }
}

