/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins;

import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.BusUtils;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.plugins.AbstractMessageBusBinderPlugin;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.core.Module;

public abstract class AbstractStreamPlugin
extends AbstractMessageBusBinderPlugin {
    public AbstractStreamPlugin(MessageBus messageBus) {
        super(messageBus);
    }

    public AbstractStreamPlugin(MessageBus messageBus, ZooKeeperConnection zkConnection) {
        super(messageBus, zkConnection);
    }

    @Override
    protected String getInputChannelName(Module module) {
        ModuleDescriptor descriptor = module.getDescriptor();
        String sourceChannel = descriptor.getSourceChannelName();
        return sourceChannel != null ? sourceChannel : BusUtils.constructPipeName((String)descriptor.getGroup(), (int)(descriptor.getIndex() - 1));
    }

    @Override
    protected String getOutputChannelName(Module module) {
        ModuleDescriptor descriptor = module.getDescriptor();
        String sinkChannel = descriptor.getSinkChannelName();
        return sinkChannel != null ? sinkChannel : BusUtils.constructPipeName((String)descriptor.getGroup(), (int)descriptor.getIndex());
    }

    @Override
    protected String buildTapChannelName(Module module) {
        Assert.isTrue((module.getType() != ModuleType.job ? 1 : 0) != 0, (String)"Job module type not supported.");
        ModuleDescriptor descriptor = module.getDescriptor();
        return String.format("%s.%s.%s", BusUtils.constructTapPrefix((String)descriptor.getGroup()), module.getName(), descriptor.getIndex());
    }

    @Override
    public boolean supports(Module module) {
        ModuleType moduleType = module.getType();
        return module.shouldBind() && (moduleType == ModuleType.source || moduleType == ModuleType.processor || moduleType == ModuleType.sink);
    }
}

