/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.plugins;

import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.plugins.AbstractMessageBusBinderPlugin;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.core.Module;

public class AbstractJobPlugin
extends AbstractMessageBusBinderPlugin {
    public AbstractJobPlugin(MessageBus messageBus) {
        super(messageBus);
    }

    public static String getJobChannelName(String jobName) {
        return "job:" + jobName;
    }

    @Override
    protected String getInputChannelName(Module module) {
        String group = module.getDescriptor().getGroup();
        return AbstractJobPlugin.getJobChannelName(group);
    }

    @Override
    protected String getOutputChannelName(Module module) {
        throw new UnsupportedOperationException("Job module doesn't have output channel set.");
    }

    @Override
    protected String buildTapChannelName(Module module) {
        throw new UnsupportedOperationException("Tap on job module is not valid as job module doesn't have an output channel.");
    }

    @Override
    public boolean supports(Module module) {
        return module.shouldBind() && module.getType() == ModuleType.job;
    }
}

