/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.xd.module.options.mixins.MaxMessagesDefaultOneMixin;
import org.springframework.xd.module.options.mixins.PeriodicTriggerMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;
import org.springframework.xd.module.options.spi.ValidationGroupsProvider;
import org.springframework.xd.module.options.validation.CronExpression;
import org.springframework.xd.module.options.validation.DateFormat;
import org.springframework.xd.module.options.validation.DateWithCustomFormat;
import org.springframework.xd.module.options.validation.Exclusives;

@Mixin(value={PeriodicTriggerMixin.class, MaxMessagesDefaultOneMixin.class})
@DateWithCustomFormat(groups={DateHasBeenSet.class})
public class TriggerSourceOptionsMetadata
implements ProfileNamesProvider,
ValidationGroupsProvider {
    private static final String[] USE_CRON = new String[]{"use-cron"};
    private static final String[] USE_DELAY = new String[]{"use-delay"};
    private static final String[] USE_DATE = new String[]{"use-date"};
    public static final String DEFAULT_DATE = "The current time";
    private Integer fixedDelay;
    private String cron;
    private String payload = "";
    private String date = "The current time";
    private String dateFormat = "MM/dd/yy HH:mm:ss";

    public String[] profilesToActivate() {
        if (this.cron != null) {
            return USE_CRON;
        }
        if (this.fixedDelay != null) {
            return USE_DELAY;
        }
        return USE_DATE;
    }

    @Min(value=0L)
    public Integer getFixedDelay() {
        return this.fixedDelay;
    }

    @AssertFalse(message="'cron', explicit 'date' and 'fixedDelay' are mutually exclusive")
    private boolean isInvalid() {
        return Exclusives.strictlyMoreThanOne((boolean[])new boolean[]{this.fixedDelay != null, this.cron != null, !DEFAULT_DATE.equals(this.date)});
    }

    @ModuleOption(value="time delay between executions, expressed in TimeUnits (seconds by default)")
    public void setFixedDelay(Integer fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    @CronExpression
    public String getCron() {
        return this.cron;
    }

    @ModuleOption(value="cron expression specifying when the trigger should fire")
    public void setCron(String cron) {
        this.cron = cron;
    }

    public String getPayload() {
        return this.payload;
    }

    @ModuleOption(value="the message that will be sent when the trigger fires")
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @NotNull
    public String getDate() {
        return this.date;
    }

    @ModuleOption(value="a one-time date when the trigger should fire; only applies if 'fixedDelay' and 'cron' are not provided")
    public void setDate(String date) {
        this.date = date;
    }

    @NotBlank
    @DateFormat
    public String getDateFormat() {
        return this.dateFormat;
    }

    @ModuleOption(value="the format specifying how the 'date' should be parsed")
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Class<?>[] groupsToValidate() {
        Class[] classArray;
        if (DEFAULT_DATE.equals(this.date)) {
            classArray = DEFAULT_GROUP;
        } else {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Default.class;
            classArray = classArray2;
            classArray2[1] = DateHasBeenSet.class;
        }
        return classArray;
    }

    public static interface DateHasBeenSet {
    }
}

