/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.AssertTrue;
import org.springframework.xd.module.options.spi.ModuleOption;

public class TailSourceOptionsMetadata {
    private int lines = 0;
    private String name = "/tmp/xd/input/${xd.stream.name}";
    private String nativeOptions;
    private long fileDelay = 5000L;
    private Long delay = null;
    private Boolean fromEnd = null;
    private Boolean reOpen = null;

    @ModuleOption(value="the number of lines prior to the end of an existing file to tail; does not apply if 'nativeOptions' is provided", defaultValue="0")
    public void setLines(int lines) {
        this.lines = lines;
    }

    public String getName() {
        return this.name;
    }

    @ModuleOption(value="the absolute path of the file to tail")
    public void setName(String name) {
        this.name = name;
    }

    public String getComputedNativeOptions() {
        if (this.nativeOptions != null) {
            return this.nativeOptions;
        }
        return this.usingApache() ? null : String.format("-F -n %d", this.lines);
    }

    private boolean usingApache() {
        return this.delay != null || this.fromEnd != null || this.reOpen != null;
    }

    private boolean usingNative() {
        return this.nativeOptions != null;
    }

    @AssertTrue(message="nativeOptions and Apache specific options are mutually exclusive")
    private boolean isValid() {
        return !this.usingApache() || !this.usingNative();
    }

    @ModuleOption(value="options for a native tail command; do not set and use 'end', 'delay', and/or 'reOpen' to use the Apache Tailer")
    public void setNativeOptions(String nativeOptions) {
        this.nativeOptions = nativeOptions;
    }

    public long getFileDelay() {
        return this.fileDelay;
    }

    @ModuleOption(value="on platforms that don't wait for a missing file to appear, how often (ms) to look for the file")
    public void setFileDelay(long fileDelay) {
        this.fileDelay = fileDelay;
    }

    public Long getDelay() {
        return this.delay;
    }

    @ModuleOption(value="how often (ms) to poll for new lines (forces use of the Apache Tailer, requires nativeOptions='')")
    public void setDelay(long delay) {
        this.delay = delay;
    }

    public Boolean getFromEnd() {
        return this.fromEnd;
    }

    @ModuleOption(value="whether to tail from the end (true) or from the start (false) of the file (forces use of the Apache Tailer, requires nativeOptions='')")
    public void setFromEnd(boolean fromEnd) {
        this.fromEnd = fromEnd;
    }

    public Boolean getReOpen() {
        return this.reOpen;
    }

    @ModuleOption(value="whether to reopen the file each time it is polled (forces use of the Apache Tailer, requires nativeOptions='')")
    public void setReOpen(boolean reOpen) {
        this.reOpen = reOpen;
    }
}

