/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.AssertTrue;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.modules.metadata.FileAsRefMixin;
import org.springframework.xd.module.options.mixins.MaxMessagesDefaultUnlimitedMixin;
import org.springframework.xd.module.options.mixins.PeriodicTriggerMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

@Mixin(value={PeriodicTriggerMixin.class, FileAsRefMixin.class, MaxMessagesDefaultUnlimitedMixin.class})
public class SftpSourceOptionsMetadata
implements ProfileNamesProvider {
    private static final String ACCEPT_ALL_FILES = "accept-all-files";
    private static final String SIMPLE_PATTERN_FILTER = "use-filename-simple-pattern";
    private static final String REGEX_PATTERN_FILTER = "use-filename-regex-pattern";
    private String host = "localhost";
    private int port = 22;
    private String user;
    private String password = "";
    private String privateKey = "";
    private String passPhrase = "";
    private String remoteDir;
    private boolean deleteRemoteFiles = false;
    private String localDir = "/tmp/xd/output";
    private boolean autoCreateLocalDir = true;
    private String tmpFileSuffix = ".tmp";
    private int fixedDelay = 1;
    private String pattern = null;
    private String regexPattern = null;
    private boolean allowUnknownKeys = false;
    private String knownHostsExpression = null;

    public String getHost() {
        return this.host;
    }

    @ModuleOption(value="the remote host to connect to")
    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    @ModuleOption(value="the remote port to connect to")
    public void setPort(int port) {
        this.port = port;
    }

    @NotBlank
    public String getUser() {
        return this.user;
    }

    @ModuleOption(value="the username to use")
    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    @ModuleOption(value="the password for the provided user")
    public void setPassword(String password) {
        this.password = password;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    @ModuleOption(value="the private key location (a valid Spring Resource URL)")
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    @ModuleOption(value="the passphrase to use")
    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    @NotBlank
    public String getRemoteDir() {
        return this.remoteDir;
    }

    @ModuleOption(value="the remote directory to transfer the files from")
    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    public boolean isDeleteRemoteFiles() {
        return this.deleteRemoteFiles;
    }

    @ModuleOption(value="delete remote files after transfer")
    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    @ModuleOption(value="set the local directory the remote files are transferred to")
    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public boolean isAutoCreateLocalDir() {
        return this.autoCreateLocalDir;
    }

    @ModuleOption(value="if local directory must be auto created if it does not exist")
    public void setAutoCreateLocalDir(boolean autoCreateLocalDir) {
        this.autoCreateLocalDir = autoCreateLocalDir;
    }

    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    @ModuleOption(value="extension to use when downloading files")
    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    public int getFixedDelay() {
        return this.fixedDelay;
    }

    @ModuleOption(value="fixed delay in SECONDS to poll the remote directory")
    public void setFixedDelay(int fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    @ModuleOption(value="filename regex pattern to apply to the filter")
    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    @ModuleOption(value="simple filename pattern to apply to the filter")
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isAllowUnknownKeys() {
        return this.allowUnknownKeys;
    }

    @ModuleOption(value="true to allow connecting to a host with an unknown or changed key")
    public void setAllowUnknownKeys(boolean allowUnknownKeys) {
        this.allowUnknownKeys = allowUnknownKeys;
    }

    public String getKnownHostsExpression() {
        return this.knownHostsExpression;
    }

    @ModuleOption(value="a SpEL expresssion location of known hosts file; required if 'allowUnknownKeys' is false; examples: systemProperties[\"user.home\"]+\"/.ssh/known_hosts\", \"/foo/bar/known_hosts\"")
    public void setKnownHostsExpression(String knownHostsExpression) {
        this.knownHostsExpression = knownHostsExpression;
    }

    @AssertTrue(message="Use ('privateKey' AND 'passphrase') OR 'password' to specify credentials")
    boolean isEitherPasswordOrPrivateKeyAndPassPhrase() {
        if (!StringUtils.hasText((String)this.password)) {
            return StringUtils.hasText((String)this.privateKey) && StringUtils.hasText((String)this.passPhrase);
        }
        return !StringUtils.hasText((String)this.privateKey) && !StringUtils.hasText((String)this.passPhrase);
    }

    public String[] profilesToActivate() {
        if (this.regexPattern != null) {
            return new String[]{REGEX_PATTERN_FILTER};
        }
        if (this.pattern != null) {
            return new String[]{SIMPLE_PATTERN_FILTER};
        }
        return new String[]{ACCEPT_ALL_FILES};
    }
}

