/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.AssertTrue;
import org.springframework.data.redis.support.collections.RedisCollectionFactoryBean;
import org.springframework.xd.dirt.modules.metadata.RedisConnectionMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

@Mixin(value={RedisConnectionMixin.class})
public class RedisSinkOptionsMetadata
implements ProfileNamesProvider {
    private static final String TOPIC_EXPRESSION_PROFILE = "use-topic-expression";
    private static final String QUEUE_EXPRESSION_PROFILE = "use-queue-expression";
    private static final String STORE_EXPRESSION_PROFILE = "use-store-expression";
    private String topic = null;
    private String queue = null;
    private String key = null;
    private String topicExpression = null;
    private String queueExpression = null;
    private String keyExpression = null;
    private RedisCollectionFactoryBean.CollectionType collectionType = RedisCollectionFactoryBean.CollectionType.LIST;

    public String getTopicExpression() {
        return this.topicExpression;
    }

    @ModuleOption(value="a SpEL expression to use for topic")
    public void setTopicExpression(String topicExpression) {
        this.topicExpression = topicExpression;
    }

    public String getQueueExpression() {
        return this.queueExpression;
    }

    @ModuleOption(value="a SpEL expression to use for queue")
    public void setQueueExpression(String queueExpression) {
        this.queueExpression = queueExpression;
    }

    public String getKeyExpression() {
        return this.keyExpression;
    }

    @ModuleOption(value="a SpEL expression to use for keyExpression")
    public void setKeyExpression(String keyExpression) {
        this.keyExpression = keyExpression;
    }

    public String getTopic() {
        return this.topic;
    }

    @ModuleOption(value="name for the topic")
    public void setTopic(String topic) {
        this.topic = topic;
        this.topicExpression = "'" + this.topic + "'";
    }

    public String getQueue() {
        return this.queue;
    }

    @ModuleOption(value="name for the queue")
    public void setQueue(String queue) {
        this.queue = queue;
        this.queueExpression = "'" + queue + "'";
    }

    public String getKey() {
        return this.key;
    }

    @ModuleOption(value="name for the key")
    public void setKey(String key) {
        this.key = key;
        this.keyExpression = "'" + this.key + "'";
    }

    public RedisCollectionFactoryBean.CollectionType getCollectionType() {
        return this.collectionType;
    }

    @ModuleOption(value="the collection type to use for the given key")
    public void setCollectionType(RedisCollectionFactoryBean.CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    @AssertTrue(message="the 'topic', 'topicExpression', 'queue', 'queueExpression', 'key' and 'keyExpression' options are mutually exclusive")
    public boolean isOptionMutuallyExclusive() {
        String[] distinctOptions;
        boolean optionSpecified = false;
        for (String option : distinctOptions = new String[]{this.topicExpression, this.queueExpression, this.keyExpression}) {
            if (optionSpecified && option != null) {
                return false;
            }
            if (option == null) continue;
            optionSpecified = true;
        }
        return this.checkMutuallyExclusive(this.queue, this.queueExpression) && this.checkMutuallyExclusive(this.topic, this.topicExpression) && this.checkMutuallyExclusive(this.key, this.keyExpression);
    }

    private boolean checkMutuallyExclusive(String literal, String expression) {
        return expression == null || literal == null ? true : expression.contains(literal) && literal.length() + 2 == expression.length();
    }

    @AssertTrue(message="one of 'topic', 'topicExpression', 'queue', 'queueExpression', 'key', 'keyExpression' options must be set explicitly")
    public boolean isOptionRequired() {
        return this.queue != null || this.topic != null || this.key != null || this.queueExpression != null || this.topicExpression != null || this.keyExpression != null;
    }

    @AssertTrue(message="collection type is not valid")
    public boolean isCollectionTypeValid() {
        for (RedisCollectionFactoryBean.CollectionType type : RedisCollectionFactoryBean.CollectionType.values()) {
            if (!type.name().equals(this.collectionType.name())) continue;
            return true;
        }
        return false;
    }

    public String[] profilesToActivate() {
        if (this.topicExpression != null) {
            return new String[]{TOPIC_EXPRESSION_PROFILE};
        }
        if (this.queueExpression != null) {
            return new String[]{QUEUE_EXPRESSION_PROFILE};
        }
        if (this.keyExpression != null) {
            return new String[]{STORE_EXPRESSION_PROFILE};
        }
        return new String[0];
    }
}

