/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.xd.module.options.spi.ModuleOption;

public class RabbitConnectionMixin {
    private String vhost = "${spring.rabbitmq.virtual_host}";
    private String username = "${spring.rabbitmq.username}";
    private String password = "${spring.rabbitmq.password}";
    private String addresses = "${spring.rabbitmq.addresses}";
    private String useSSL = "${spring.rabbitmq.useSSL}";
    private String sslPropertiesLocation = "${spring.rabbitmq.sslProperties}";
    private String keyStore = "${spring.rabbitmq.ssl.keyStore}";
    private String keyStorePassphrase = "${spring.rabbitmq.ssl.keyStorePassphrase}";
    private String trustStore = "${spring.rabbitmq.ssl.trustStore}";
    private String trustStorePassphrase = "${spring.rabbitmq.ssl.trustStorePassphrase}";

    @NotBlank
    public String getUsername() {
        return this.username;
    }

    @ModuleOption(value="the username to use to connect to the broker")
    public void setUsername(String username) {
        this.username = username;
    }

    @NotBlank
    public String getPassword() {
        return this.password;
    }

    @ModuleOption(value="the password to use to connect to the broker")
    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddresses() {
        return this.addresses;
    }

    @ModuleOption(value="a comma separated list of 'host[:port]' addresses")
    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getVhost() {
        return this.vhost;
    }

    @ModuleOption(value="the RabbitMQ virtual host to use", hidden=true)
    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getUseSSL() {
        return this.useSSL;
    }

    @ModuleOption(value="true if SSL should be used for the connection", hidden=true)
    public void setUseSSL(String useSSL) {
        this.useSSL = useSSL;
    }

    public String getSslPropertiesLocation() {
        return this.sslPropertiesLocation;
    }

    @ModuleOption(value="resource containing SSL properties", hidden=true)
    public void setSslPropertiesLocation(String sslPropertiesLocation) {
        this.sslPropertiesLocation = sslPropertiesLocation;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    @ModuleOption(value="keyStore location (if not using SSL properties)", hidden=true)
    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    @ModuleOption(value="keyStore passphrase (if not using SSL properties)", hidden=true)
    public void setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    @ModuleOption(value="trustStore location (if not using SSL properties)", hidden=true)
    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    @ModuleOption(value="trustStore passphrase (if not using SSL properties)", hidden=true)
    public void setTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
    }
}

