/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.xd.dirt.modules.metadata.MqttConnectionMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;

@Mixin(value={MqttConnectionMixin.class})
public class MqttSourceOptionsMetadata {
    private String clientId = "xd.mqtt.client.id.src";
    private String topics = "xd.mqtt.test";
    private String qos = "0";
    private boolean binary = false;
    private String charset = "UTF-8";

    @NotBlank
    @Size(min=1, max=23)
    public String getClientId() {
        return this.clientId;
    }

    @ModuleOption(value="identifies the client")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @NotBlank
    public String getTopics() {
        return this.topics;
    }

    @ModuleOption(value="the topic(s) (comma-delimited) to which the source will subscribe")
    public void setTopics(String topics) {
        this.topics = topics;
    }

    public String getQos() {
        return this.qos;
    }

    @ModuleOption(value="the qos; a single value for all topics or a comma-delimited list to match the topics")
    public void setQos(String qos) {
        this.qos = qos;
    }

    public String getCharset() {
        return this.charset;
    }

    @ModuleOption(value="the charset used to convert bytes to String (when binary is false)")
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isBinary() {
        return this.binary;
    }

    @ModuleOption(value="true to leave the payload as bytes")
    public void setBinary(boolean binary) {
        this.binary = binary;
    }
}

