/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;
import org.springframework.xd.dirt.modules.metadata.MqttConnectionMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;

@Mixin(value={MqttConnectionMixin.class})
public class MqttSinkOptionsMetadata {
    private String clientId = "xd.mqtt.client.id.snk";
    private String topic = "xd.mqtt.test";
    private int qos = 1;
    private boolean retained = false;
    private String charset = "UTF-8";
    private boolean async = false;

    @Range(min=0L, max=2L)
    public int getQos() {
        return this.qos;
    }

    public boolean isRetained() {
        return this.retained;
    }

    @ModuleOption(value="the quality of service to use")
    public void setQos(int qos) {
        this.qos = qos;
    }

    @ModuleOption(value="whether to set the 'retained' flag")
    public void setRetained(boolean retained) {
        this.retained = retained;
    }

    @NotBlank
    @Size(min=1, max=23)
    public String getClientId() {
        return this.clientId;
    }

    @ModuleOption(value="identifies the client")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @NotBlank
    public String getTopic() {
        return this.topic;
    }

    @ModuleOption(value="the topic to which the sink will publish")
    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getCharset() {
        return this.charset;
    }

    @ModuleOption(value="the charset used to convert a String payload to byte[]")
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isAsync() {
        return this.async;
    }

    @ModuleOption(value="whether or not to use async sends")
    public void setAsync(boolean async) {
        this.async = async;
    }
}

