/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

public class JmsSourceModuleOptionsMetadata
implements ProfileNamesProvider {
    private String provider = "activemq";
    private String destination = "${xd.stream.name}";
    private boolean pubSub = false;
    private boolean durableSubscription = false;
    private String subscriptionName = null;
    private String clientId = null;
    private String acknowledge = "auto";

    @NotNull
    public String getProvider() {
        return this.provider;
    }

    @NotNull
    public String getDestination() {
        return this.destination;
    }

    public boolean isPubSub() {
        return this.pubSub;
    }

    public boolean isDurableSubscription() {
        return this.durableSubscription;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getClientId() {
        return this.clientId;
    }

    @NotNull
    @Pattern(regexp="(auto|transacted|dups-ok|client)", flags={Pattern.Flag.CASE_INSENSITIVE}, message="must be one of 'auto', 'transacted', 'dups-ok' or 'client'")
    public String getAcknowledge() {
        return this.acknowledge;
    }

    @ModuleOption(value="the JMS provider")
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @ModuleOption(value="the destination name from which messages will be received")
    public void setDestination(String destination) {
        this.destination = destination;
    }

    @ModuleOption(value="when true, indicates that the destination is a topic")
    public void setPubSub(boolean pubSub) {
        this.pubSub = pubSub;
    }

    @ModuleOption(value="when true, indicates the subscription to a topic is durable")
    public void setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
    }

    @ModuleOption(value="a name that will be assigned to the topic subscription")
    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @ModuleOption(value="an identifier for the client, to be associated with a durable topic subscription")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ModuleOption(value="the session acknowledge mode")
    public void setAcknowledge(String acknowledge) {
        this.acknowledge = acknowledge.toLowerCase();
    }

    public String[] profilesToActivate() {
        if ("transacted".equals(this.acknowledge)) {
            return new String[]{"dmlc"};
        }
        return new String[]{"smlc"};
    }
}

