/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.xd.dirt.modules.metadata.FileAsRefMixin;
import org.springframework.xd.module.options.mixins.FtpConnectionMixin;
import org.springframework.xd.module.options.mixins.MaxMessagesDefaultUnlimitedMixin;
import org.springframework.xd.module.options.mixins.PeriodicTriggerMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;

@Mixin(value={FtpConnectionMixin.class, PeriodicTriggerMixin.class, FileAsRefMixin.class, MaxMessagesDefaultUnlimitedMixin.class})
public class FtpSourceOptionsMetadata {
    private int clientMode = 0;
    private String remoteDir = "/";
    private boolean deleteRemoteFiles = false;
    private String localDir = "/tmp/xd/ftp";
    private boolean autoCreateLocalDir = true;
    private String tmpFileSuffix = ".tmp";
    private int fixedDelay = 1;
    private String filenamePattern = "*";
    private String remoteFileSeparator = "/";
    private boolean preserveTimestamp = true;

    @NotBlank
    public String getRemoteDir() {
        return this.remoteDir;
    }

    @ModuleOption(value="the remote directory to transfer the files from")
    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    public boolean isDeleteRemoteFiles() {
        return this.deleteRemoteFiles;
    }

    @ModuleOption(value="delete remote files after transfer")
    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    @NotBlank
    public String getLocalDir() {
        return this.localDir;
    }

    @ModuleOption(value="set the local directory the remote files are transferred to")
    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public boolean isAutoCreateLocalDir() {
        return this.autoCreateLocalDir;
    }

    @ModuleOption(value="local directory must be auto created if it does not exist")
    public void setAutoCreateLocalDir(boolean autoCreateLocalDir) {
        this.autoCreateLocalDir = autoCreateLocalDir;
    }

    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    @ModuleOption(value="extension to use when downloading files")
    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    @Min(value=0L)
    public int getFixedDelay() {
        return this.fixedDelay;
    }

    @ModuleOption(value="the rate at which to poll the remote directory")
    public void setFixedDelay(int fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    @NotBlank
    public String getFilenamePattern() {
        return this.filenamePattern;
    }

    @ModuleOption(value="simple filename pattern to apply to the filter")
    public void setFilenamePattern(String pattern) {
        this.filenamePattern = pattern;
    }

    public int getClientMode() {
        return this.clientMode;
    }

    @ModuleOption(value="client mode to use : 2 for passive mode and 0 for active mode")
    public void setClientMode(int clientMode) {
        this.clientMode = clientMode;
    }

    @NotBlank
    public String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    @ModuleOption(value="file separator to use on the remote side")
    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }

    @ModuleOption(value="whether to preserve the timestamp of files retrieved")
    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public boolean isPreserveTimestamp() {
        return this.preserveTimestamp;
    }
}

