/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import org.hibernate.validator.constraints.NotBlank;
import org.springframework.xd.dirt.modules.metadata.FileSinkOptionsMetadata;
import org.springframework.xd.module.options.mixins.FtpConnectionMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;

@Mixin(value={FtpConnectionMixin.class})
public class FtpSinkOptionsMetadata {
    private int clientMode = 0;
    private String remoteDir = "/";
    private String temporaryRemoteDir = "/";
    private boolean autoCreateDir = true;
    private String remoteFileSeparator = "/";
    private String tmpFileSuffix = ".tmp";
    private FileSinkOptionsMetadata.Mode mode = FileSinkOptionsMetadata.Mode.REPLACE;
    private boolean useTemporaryFilename = true;

    public boolean isUseTemporaryFilename() {
        return this.useTemporaryFilename;
    }

    @ModuleOption(value="use a temporary filename while transferring the file and rename it to its final name once it's fully transferred")
    public void setUseTemporaryFilename(boolean useTemporaryFilename) {
        this.useTemporaryFilename = useTemporaryFilename;
    }

    public FileSinkOptionsMetadata.Mode getMode() {
        return this.mode;
    }

    @ModuleOption(value="what to do if the file already exists")
    public void setMode(FileSinkOptionsMetadata.Mode mode) {
        this.mode = mode;
    }

    public String getRemoteDir() {
        return this.remoteDir;
    }

    @ModuleOption(value="the remote directory to transfer the files to")
    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    public String getTemporaryRemoteDir() {
        return this.temporaryRemoteDir;
    }

    @ModuleOption(value="temporary remote directory that should be used")
    public void setTemporaryRemoteDir(String temporaryRemoteDir) {
        this.temporaryRemoteDir = temporaryRemoteDir;
    }

    public boolean isAutoCreateDir() {
        return this.autoCreateDir;
    }

    @ModuleOption(value="remote directory must be auto created if it does not exist")
    public void setAutoCreateDir(boolean autoCreateDir) {
        this.autoCreateDir = autoCreateDir;
    }

    public String getTmpFileSuffix() {
        return this.tmpFileSuffix;
    }

    @ModuleOption(value="extension to use on server side when uploading files")
    public void setTmpFileSuffix(String tmpFileSuffix) {
        this.tmpFileSuffix = tmpFileSuffix;
    }

    public int getClientMode() {
        return this.clientMode;
    }

    @ModuleOption(value="client mode to use: 2 for passive mode and 0 for active mode")
    public void setClientMode(int clientMode) {
        this.clientMode = clientMode;
    }

    @NotBlank
    public String getRemoteFileSeparator() {
        return this.remoteFileSeparator;
    }

    @ModuleOption(value="file separator to use on the remote side")
    public void setRemoteFileSeparator(String remoteFileSeparator) {
        this.remoteFileSeparator = remoteFileSeparator;
    }
}

