/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.util.StringUtils;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

public class FileSinkOptionsMetadata
implements ProfileNamesProvider {
    private static final String USE_SPEL_PROFILE = "use-expression";
    private static final String USE_LITERAL_STRING_PROFILE = "use-string";
    private boolean binary = false;
    private String charset = "UTF-8";
    private String dir = "/tmp/xd/output/";
    private String name = "${xd.stream.name}";
    private String suffix = "out";
    private Mode mode = Mode.APPEND;
    private String nameExpression;
    private String dirExpression;

    @NotNull
    public Mode getMode() {
        return this.mode;
    }

    @ModuleOption(value="what to do if the file already exists")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getExtensionWithDot() {
        return StringUtils.hasText((String)this.suffix) ? "." + this.suffix.trim() : "";
    }

    @ModuleOption(value="filename extension to use")
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getName() {
        return this.name;
    }

    @ModuleOption(value="filename pattern to use")
    public void setName(String name) {
        this.name = name;
    }

    @NotBlank
    public String getDir() {
        return this.dir;
    }

    @ModuleOption(value="the directory in which files will be created")
    public void setDir(String dir) {
        this.dir = dir;
    }

    public boolean isBinary() {
        return this.binary;
    }

    @ModuleOption(value="if false, will append a newline character at the end of each line")
    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    @ModuleOption(value="the charset to use when writing a String payload")
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @NotBlank
    public String getCharset() {
        return this.charset;
    }

    public String getNameExpression() {
        return this.nameExpression;
    }

    @ModuleOption(value="spring expression used to define filename")
    public void setNameExpression(String nameExpression) {
        this.nameExpression = nameExpression;
    }

    public String getDirExpression() {
        return this.dirExpression;
    }

    @ModuleOption(value="spring expression used to define directory name")
    public void setDirExpression(String dirExpression) {
        this.dirExpression = dirExpression;
    }

    public String[] profilesToActivate() {
        String[] stringArray;
        if (this.nameExpression != null || this.dirExpression != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = USE_SPEL_PROFILE;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = USE_LITERAL_STRING_PROFILE;
        }
        return stringArray;
    }

    public static enum Mode {
        APPEND,
        REPLACE,
        FAIL,
        IGNORE;

    }
}

