/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import org.springframework.xd.dirt.modules.metadata.FileReadingMode;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

public class FileAsRefMixin
implements ProfileNamesProvider {
    private FileReadingMode fileReadingmode = FileReadingMode.contents;
    private Boolean withMarkers = null;

    @NotNull
    public FileReadingMode getMode() {
        return this.fileReadingmode;
    }

    @ModuleOption(value="specifies how the file is being read. By default the content of a file is provided as byte array")
    public void setMode(FileReadingMode mode) {
        this.fileReadingmode = mode;
    }

    public Boolean getWithMarkers() {
        return this.withMarkers;
    }

    @ModuleOption(defaultValue="false", value="if true emits start of file/end of file marker messages before/after the data. Only valid with FileReadingMode 'lines'")
    public void setWithMarkers(Boolean withMarkers) {
        this.withMarkers = withMarkers;
    }

    @AssertTrue(message="withMarkers can only be supplied when FileReadingMode is 'lines'")
    public boolean isWithMarkersValid() {
        return this.withMarkers == null || FileReadingMode.lines.equals((Object)this.fileReadingmode);
    }

    public String[] profilesToActivate() {
        return new String[]{this.fileReadingmode.getProfile()};
    }
}

