/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.modules.metadata;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;
import org.springframework.xd.module.options.spi.ValidationGroupsProvider;

public class AggregatorProcessorModuleOptionsMetadata
implements ProfileNamesProvider,
ValidationGroupsProvider {
    private String correlation = "'${xd.stream.name}'";
    private String release;
    private int count = 50;
    private String aggregation = "#this.![payload]";
    private int timeout = 50000;
    private StoreKind store = StoreKind.memory;
    private String hostname = "localhost";
    private int port = 6379;
    private boolean initializeDatabase;
    private String dbkind;
    private String driverClassName;
    private String url;
    private String username;
    private String password = "";

    @ModuleOption(value="how to correlate messages (SpEL expression against each message)")
    public void setCorrelation(String correlation) {
        this.correlation = correlation;
    }

    @ModuleOption(value="when to release messages (SpEL expression against a collection of messages accumulated so far)")
    public void setRelease(String release) {
        this.release = release;
    }

    @ModuleOption(value="the number of messages to group together before emitting a group")
    public void setCount(int count) {
        if (this.release == null) {
            this.release = String.format("size() == %d", count);
        }
        this.count = count;
    }

    @ModuleOption(value="how to construct the aggregated message (SpEL expression against a collection of messages)")
    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    @ModuleOption(value="the delay (ms) after which messages should be released, even if the completion criteria is not met")
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @ModuleOption(value="the kind of store to use to retain messages")
    public void setStore(StoreKind store) {
        this.store = store;
    }

    @ModuleOption(value="hostname of the redis instance to use as a store")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @ModuleOption(value="port of the redis instance to use as a store")
    public void setPort(int port) {
        this.port = port;
    }

    @ModuleOption(value="whether to auto-create the database tables for the jdbc store")
    public void setInitializeDatabase(boolean initializeDatabase) {
        this.initializeDatabase = initializeDatabase;
    }

    @ModuleOption(value="which flavor of init scripts to use for the jdbc store (blank to attempt autodetection)")
    public void setDbkind(String dbkind) {
        this.dbkind = dbkind;
    }

    @ModuleOption(value="the jdbc driver to use when using the jdbc store")
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @ModuleOption(value="the jdbc url to connect to when using the jdbc store")
    public void setUrl(String url) {
        this.url = url;
    }

    @ModuleOption(value="the username to use when using the jdbc store")
    public void setUsername(String username) {
        this.username = username;
    }

    @ModuleOption(value="the password to use when using the jdbc or redis store")
    public void setPassword(String password) {
        this.password = password;
    }

    public String getCorrelation() {
        return this.correlation;
    }

    @NotNull
    public String getRelease() {
        return this.release;
    }

    @Min(value=0L)
    public int getCount() {
        return this.count;
    }

    @NotNull
    public String getAggregation() {
        return this.aggregation;
    }

    @Min(value=0L)
    public int getTimeout() {
        return this.timeout;
    }

    @NotNull
    public StoreKind getStore() {
        return this.store;
    }

    @NotNull(groups={RedisStore.class})
    public String getHostname() {
        return this.hostname;
    }

    @Range(min=0L, max=65535L, groups={RedisStore.class})
    @NotNull(groups={RedisStore.class})
    public Integer getPort() {
        return this.port;
    }

    public boolean isInitializeDatabase() {
        return this.initializeDatabase;
    }

    public String getDbkind() {
        return this.dbkind;
    }

    @NotBlank(groups={JdbcStore.class})
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @NotBlank(groups={JdbcStore.class})
    public String getUrl() {
        return this.url;
    }

    @NotBlank(groups={JdbcStore.class})
    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] profilesToActivate() {
        return new String[]{String.format("use-%s-store", new Object[]{this.store})};
    }

    public Class<?>[] groupsToValidate() {
        switch (this.store) {
            case jdbc: {
                return new Class[]{JdbcStore.class};
            }
            case redis: {
                return new Class[]{RedisStore.class};
            }
        }
        return new Class[]{Default.class};
    }

    private static interface JdbcStore
    extends Default {
    }

    private static interface RedisStore
    extends Default {
    }

    public static enum StoreKind {
        memory,
        jdbc,
        redis;

    }
}

