/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.xd.dirt.job.dsl.ComposedJobUtil;
import org.springframework.xd.dirt.job.dsl.JobParser;
import org.springframework.xd.dirt.module.DependencyException;
import org.springframework.xd.dirt.module.ModuleAlreadyExistsException;
import org.springframework.xd.dirt.module.ModuleDependencyRepository;
import org.springframework.xd.dirt.module.NoSuchModuleException;
import org.springframework.xd.dirt.module.UploadedModuleDefinition;
import org.springframework.xd.dirt.module.WritableModuleRegistry;
import org.springframework.xd.dirt.stream.ParsingContext;
import org.springframework.xd.dirt.stream.XDStreamParser;
import org.springframework.xd.dirt.util.PagingUtility;
import org.springframework.xd.module.CompositeModuleDefinition;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDefinitions;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;

public class ModuleDefinitionService {
    private final WritableModuleRegistry registry;
    private final XDStreamParser parser;
    private final ModuleDependencyRepository dependencyRepository;
    private final PagingUtility<ModuleDefinition> pagingUtility = new PagingUtility();
    private final JobParser composedJobParser;

    @Autowired
    public ModuleDefinitionService(WritableModuleRegistry registry, XDStreamParser parser, ModuleDependencyRepository dependencyRepository) {
        this.registry = registry;
        this.parser = parser;
        this.dependencyRepository = dependencyRepository;
        this.composedJobParser = new JobParser();
    }

    public ModuleDefinition findDefinition(String name, ModuleType type) {
        return this.registry.findDefinition(name, type);
    }

    public Page<ModuleDefinition> findDefinitions(Pageable pageable, String name) {
        List<ModuleDefinition> raw = this.registry.findDefinitions(name);
        return this.pagingUtility.getPagedData(pageable, raw);
    }

    public Page<ModuleDefinition> findDefinitions(Pageable pageable, ModuleType type) {
        List<ModuleDefinition> raw = this.registry.findDefinitions(type);
        return this.pagingUtility.getPagedData(pageable, raw);
    }

    public Page<ModuleDefinition> findDefinitions(Pageable pageable) {
        List<ModuleDefinition> raw = this.registry.findDefinitions();
        return this.pagingUtility.getPagedData(pageable, raw);
    }

    public ModuleDefinition compose(String name, ModuleType typeHint, String dslDefinition, boolean force) {
        ModuleDefinition moduleDefinition = null;
        moduleDefinition = typeHint == ModuleType.job ? this.composeJob(name, typeHint, dslDefinition, force) : this.composeStream(name, typeHint, dslDefinition, force);
        return moduleDefinition;
    }

    private ModuleDefinition composeJob(String name, ModuleType typeHint, String dslDefinition, boolean force) {
        this.assertModuleUpdatability(name, typeHint, force);
        String composedJobXml = this.composedJobParser.parse(dslDefinition).toXML(name);
        byte[] bytes = this.createComposedJobJar(composedJobXml);
        UploadedModuleDefinition moduleDefinition = new UploadedModuleDefinition(name, typeHint, bytes);
        Assert.isTrue((boolean)this.registry.registerNew(moduleDefinition), (String)((Object)((Object)moduleDefinition) + " could not be saved"));
        return moduleDefinition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] createComposedJobJar(String xml) {
        ZipOutputStream target = null;
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            target = new JarOutputStream(outStream);
            JarEntry entry = new JarEntry("config/");
            ((JarOutputStream)target).putNextEntry(entry);
            target.closeEntry();
            this.writeXML((JarOutputStream)target, xml);
            this.writeParameters((JarOutputStream)target, ComposedJobUtil.getPropertyDefinition());
            target.close();
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            try {
                if (target == null) throw new IllegalStateException(e.getMessage(), e);
                target.close();
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (IOException ie) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    private void writeXML(JarOutputStream target, String xml) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes(Charset.forName(StandardCharsets.UTF_8.name())));){
            JarEntry entry = new JarEntry("config/composedjob.xml");
            target.putNextEntry(entry);
            StreamUtils.copy((InputStream)in, (OutputStream)target);
            target.closeEntry();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage(), ioe);
        }
    }

    private void writeParameters(JarOutputStream target, String parameters) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(parameters.getBytes(Charset.forName("UTF-8")));){
            JarEntry entry = new JarEntry("config/composedjob.properties");
            target.putNextEntry(entry);
            StreamUtils.copy((InputStream)in, (OutputStream)target);
            target.closeEntry();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage(), ioe);
        }
    }

    private ModuleDefinition composeStream(String name, ModuleType typeHint, String dslDefinition, boolean force) {
        List<ModuleDescriptor> parseResult = this.parser.parse(name, dslDefinition, ParsingContext.module);
        ModuleType type = this.determineType(parseResult);
        this.assertModuleUpdatability(name, type, force);
        List<ModuleDefinition> composedModuleDefinitions = this.createComposedModuleDefinitions(parseResult);
        CompositeModuleDefinition moduleDefinition = ModuleDefinitions.composed((String)name, (ModuleType)type, (String)dslDefinition, composedModuleDefinitions);
        Assert.isTrue((boolean)this.registry.registerNew((ModuleDefinition)moduleDefinition), (String)(moduleDefinition + " could not be saved"));
        return moduleDefinition;
    }

    public ModuleDefinition upload(String name, ModuleType type, byte[] bytes, boolean force) {
        this.assertModuleUpdatability(name, type, force);
        UploadedModuleDefinition definition = new UploadedModuleDefinition(name, type, bytes);
        Assert.isTrue((boolean)this.registry.registerNew(definition), (String)((Object)((Object)definition) + " could not be saved"));
        return definition;
    }

    private void assertModuleUpdatability(String name, ModuleType type, boolean force) {
        ModuleDefinition definition = this.registry.findDefinition(name, type);
        if (definition != null) {
            if (!force) {
                throw new ModuleAlreadyExistsException(name, type);
            }
            Set<String> dependents = this.dependencyRepository.find(name, type);
            if (!dependents.isEmpty()) {
                throw new DependencyException("Cannot force update module %2$s:%1$s because it is used by %3$s", name, type, dependents);
            }
            if (!this.registry.delete(definition)) {
                throw new ModuleAlreadyExistsException("There is already a module named '%s' with type '%s', and it cannot be updated", name, type);
            }
        }
    }

    public void delete(String name, ModuleType type) {
        ModuleDefinition definition = this.registry.findDefinition(name, type);
        if (definition == null) {
            throw new NoSuchModuleException(name, type);
        }
        Set<String> dependents = this.dependencyRepository.find(name, type);
        if (!dependents.isEmpty()) {
            throw new DependencyException("Cannot delete module %2$s:%1$s because it is used by %3$s", name, type, dependents);
        }
        boolean result = this.registry.delete(definition);
        Assert.isTrue((boolean)result, (String)String.format("Could not delete module '%s:%s'", type, name));
    }

    private List<ModuleDefinition> createComposedModuleDefinitions(List<ModuleDescriptor> moduleDescriptors) {
        ArrayList<ModuleDefinition> moduleDefinitions = new ArrayList<ModuleDefinition>(moduleDescriptors.size());
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            moduleDefinitions.add(this.registry.findDefinition(moduleDescriptor.getModuleName(), moduleDescriptor.getType()));
        }
        return moduleDefinitions;
    }

    private ModuleType determineType(List<ModuleDescriptor> modules) {
        boolean hasOutput;
        Assert.isTrue((modules != null && modules.size() > 0 ? 1 : 0) != 0, (String)"at least one module required");
        if (modules.size() == 1) {
            return modules.get(0).getType();
        }
        Collections.sort(modules);
        ModuleType firstType = modules.get(0).getType();
        ModuleType lastType = modules.get(modules.size() - 1).getType();
        boolean hasInput = firstType != ModuleType.source;
        boolean bl = hasOutput = lastType != ModuleType.sink;
        if (hasInput && hasOutput) {
            return ModuleType.processor;
        }
        if (hasInput) {
            return ModuleType.sink;
        }
        if (hasOutput) {
            return ModuleType.source;
        }
        throw new IllegalArgumentException("invalid module composition; must expose input and/or output channel");
    }
}

