/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.support;

import java.util.List;
import org.springframework.xd.dirt.module.ModuleDependencyRepository;
import org.springframework.xd.module.CompositeModuleDefinition;
import org.springframework.xd.module.ModuleDefinition;

public abstract class ModuleDefinitionRepositoryUtils {
    public static void saveDependencies(ModuleDependencyRepository moduleDependencyRepository, ModuleDefinition source, String target) {
        moduleDependencyRepository.store(source.getName(), source.getType(), target);
        if (source.isComposed()) {
            List children = ((CompositeModuleDefinition)source).getChildren();
            for (ModuleDefinition child : children) {
                ModuleDefinitionRepositoryUtils.saveDependencies(moduleDependencyRepository, child, target);
            }
        }
    }

    public static void deleteDependencies(ModuleDependencyRepository moduleDependencyRepository, ModuleDefinition source, String target) {
        moduleDependencyRepository.delete(source.getName(), source.getType(), target);
        if (source.isComposed()) {
            List children = ((CompositeModuleDefinition)source).getChildren();
            for (ModuleDefinition child : children) {
                ModuleDefinitionRepositoryUtils.deleteDependencies(moduleDependencyRepository, child, target);
            }
        }
    }
}

