/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.core.ModuleDeploymentsPath;
import org.springframework.xd.dirt.module.store.ModuleMetadata;
import org.springframework.xd.dirt.module.store.ModuleMetadataRepository;
import org.springframework.xd.dirt.stream.JobRepository;
import org.springframework.xd.dirt.stream.StreamRepository;
import org.springframework.xd.dirt.util.PagingUtility;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleType;

public class ZooKeeperModuleMetadataRepository
implements ModuleMetadataRepository {
    private static final String XD_MODULE_PROPERTIES_PREFIX = "xd.";
    private final ZooKeeperConnection zkConnection;
    private final StreamRepository streamRepository;
    private final JobRepository jobRepository;
    private final PagingUtility<ModuleMetadata> pagingUtility = new PagingUtility();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public ZooKeeperModuleMetadataRepository(ZooKeeperConnection zkConnection, StreamRepository streamRepository, JobRepository jobRepository) {
        this.zkConnection = zkConnection;
        this.streamRepository = streamRepository;
        this.jobRepository = jobRepository;
    }

    public Iterable<ModuleMetadata> findAll(Sort sort) {
        return this.findAll();
    }

    public Page<ModuleMetadata> findAll(Pageable pageable) {
        return this.pagingUtility.getPagedData(pageable, (List<ModuleMetadata>)this.findAll());
    }

    @Override
    public ModuleMetadata findOne(String containerId, String moduleId) {
        return this.findOne(new ModuleMetadata.Id(containerId, moduleId));
    }

    @Override
    public Page<ModuleMetadata> findAllByContainerId(Pageable pageable, String containerId) {
        Assert.hasText((String)containerId, (String)"containerId is required");
        return this.pagingUtility.getPagedData(pageable, (List<ModuleMetadata>)this.findAllByContainerId(containerId));
    }

    @Override
    public Page<ModuleMetadata> findAllByModuleId(Pageable pageable, String moduleId) {
        Assert.hasText((String)moduleId, (String)"moduleId is required");
        ArrayList<ModuleMetadata> results = new ArrayList<ModuleMetadata>();
        for (String containerId : this.getAvailableContainerIds()) {
            ModuleMetadata metadata = this.findOne(new ModuleMetadata.Id(containerId, moduleId));
            if (metadata == null) continue;
            results.add(metadata);
        }
        return this.pagingUtility.getPagedData(pageable, results);
    }

    public ModuleMetadata findOne(ModuleMetadata.Id id) {
        Assert.notNull((Object)id, (String)"id is required");
        String moduleDeploymentPath = this.moduleDeploymentPath(id);
        String metadataPath = Paths.build(moduleDeploymentPath, "metadata");
        ModuleMetadata metadata = null;
        try {
            byte[] data = (byte[])this.zkConnection.getClient().getData().forPath(metadataPath);
            if (data != null) {
                Map<String, String> metadataMap = ZooKeeperUtils.bytesToMap(data);
                new ModuleDeploymentsPath(moduleDeploymentPath);
                ModuleType moduleType = id.getModuleType();
                DeploymentUnitStatus status = moduleType == ModuleType.job ? this.jobRepository.getDeploymentStatus((Serializable)((Object)id.getUnitName())) : this.streamRepository.getDeploymentStatus((Serializable)((Object)id.getUnitName()));
                metadata = new ModuleMetadata(id, this.getResolvedModuleOptions(metadataMap), this.getDeploymentProperties(moduleDeploymentPath), status.getState());
            }
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
        return metadata;
    }

    private Properties getDeploymentProperties(String moduleDeploymentsPath) {
        Map<Object, Object> deploymentProperties = new HashMap();
        try {
            deploymentProperties = ZooKeeperUtils.bytesToMap((byte[])this.zkConnection.getClient().getData().forPath(moduleDeploymentsPath));
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
        return MapUtils.toProperties(deploymentProperties);
    }

    private Properties getResolvedModuleOptions(Map<String, String> metadataMap) {
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : metadataMap.entrySet()) {
            String placeholderKey;
            String propertyKey = entry.getKey();
            String propertyValue = entry.getValue();
            if (propertyKey.startsWith(XD_MODULE_PROPERTIES_PREFIX) || StringUtils.isEmpty((Object)propertyValue)) continue;
            if (propertyValue.startsWith("${") && propertyValue.endsWith("}") && metadataMap.get(placeholderKey = propertyValue.substring(2, propertyValue.length() - 1)) != null) {
                propertyValue = metadataMap.get(placeholderKey);
            }
            optionsMap.put(propertyKey, propertyValue);
        }
        return MapUtils.toProperties(optionsMap);
    }

    public boolean exists(ModuleMetadata.Id id) {
        try {
            return this.zkConnection.getClient().checkExists().forPath(this.moduleDeploymentPath(id)) != null;
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<ModuleMetadata> findAll() {
        ArrayList<ModuleMetadata> results = new ArrayList<ModuleMetadata>();
        try {
            for (String containerId : this.getAvailableContainerIds()) {
                List<ModuleMetadata.Id> modules = this.getDeployedModules(containerId);
                for (ModuleMetadata.Id moduleId : modules) {
                    ModuleMetadata metadata = this.findOne(moduleId);
                    if (metadata == null) continue;
                    results.add(metadata);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    private List<String> getAvailableContainerIds() {
        try {
            return (List)this.zkConnection.getClient().getChildren().forPath("containers");
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<ModuleMetadata> findAllByContainerId(String containerId) {
        Assert.hasText((String)containerId, (String)"containerId is required");
        List<ModuleMetadata.Id> deployedModules = this.getDeployedModules(containerId);
        this.logger.debug("deployedModules: {}", deployedModules);
        ArrayList<ModuleMetadata> results = new ArrayList<ModuleMetadata>(deployedModules.size());
        for (ModuleMetadata.Id moduleId : deployedModules) {
            ModuleMetadata metadata = this.findOne(moduleId);
            this.logger.debug("found metadata: {}", (Object)metadata);
            if (metadata == null) continue;
            results.add(metadata);
        }
        return results;
    }

    private List<ModuleMetadata.Id> getDeployedModules(String containerId) {
        ArrayList<ModuleMetadata.Id> ids = new ArrayList<ModuleMetadata.Id>();
        try {
            CuratorFramework client = this.zkConnection.getClient();
            if (client.checkExists().forPath(Paths.build("containers", containerId)) != null) {
                List qualifiedIds = (List)client.getChildren().forPath(this.containerAllocationPath(containerId));
                for (String qualifiedId : qualifiedIds) {
                    ids.add(new ModuleMetadata.Id(containerId, qualifiedId));
                }
            }
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
        return ids;
    }

    public Iterable<ModuleMetadata> findAll(Iterable<ModuleMetadata.Id> ids) {
        ArrayList<ModuleMetadata> results = new ArrayList<ModuleMetadata>();
        for (ModuleMetadata.Id id : ids) {
            ModuleMetadata entity = this.findOne(id);
            if (entity == null) continue;
            results.add(entity);
        }
        return results;
    }

    public Iterable<ModuleMetadata> findAllInRange(ModuleMetadata.Id from, boolean fromInclusive, ModuleMetadata.Id to, boolean toInclusive) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public long count() {
        long count = 0L;
        try {
            List containerIds = (List)this.zkConnection.getClient().getChildren().forPath("deployments/modules");
            for (String containerId : containerIds) {
                Stat stat = (Stat)this.zkConnection.getClient().checkExists().forPath(this.containerAllocationPath(containerId));
                if (stat == null) continue;
                count += (long)stat.getNumChildren();
            }
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return count;
    }

    private String containerAllocationPath(String id) {
        return Paths.build("deployments/modules", "allocated", id);
    }

    private String moduleDeploymentPath(ModuleMetadata.Id id) {
        return Paths.build("deployments/modules", "allocated", id.getContainerId(), id.getFullyQualifiedId());
    }

    public <S extends ModuleMetadata> S save(S entity) {
        throw new UnsupportedOperationException();
    }

    public <S extends ModuleMetadata> Iterable<S> save(Iterable<S> entities) {
        throw new UnsupportedOperationException();
    }

    public void delete(ModuleMetadata.Id id) {
        throw new UnsupportedOperationException();
    }

    public void delete(ModuleMetadata entity) {
        throw new UnsupportedOperationException();
    }

    public void delete(Iterable<? extends ModuleMetadata> entities) {
        throw new UnsupportedOperationException();
    }

    public void deleteAll() {
        throw new UnsupportedOperationException();
    }
}

