/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.store;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.zookeeper.KeeperException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.xd.dirt.module.ModuleDependencyRepository;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleType;

public class ZooKeeperModuleDependencyRepository
implements ModuleDependencyRepository {
    private static final String MODULES_NODE = "modules";
    private static final String DEPENDENCIES_NODE = "dependencies";
    private final ZooKeeperConnection connection;

    @Autowired
    public ZooKeeperModuleDependencyRepository(ZooKeeperConnection connection) {
        this.connection = connection;
    }

    @Override
    public void store(String moduleName, ModuleType type, String target) {
        String path = Paths.build(MODULES_NODE, type.toString(), moduleName, DEPENDENCIES_NODE, target);
        try {
            this.connection.getClient().create().creatingParentsIfNeeded().forPath(path);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NodeExistsException.class);
        }
    }

    @Override
    public Set<String> find(String name, ModuleType type) {
        String path = Paths.build(MODULES_NODE, type.toString(), name, DEPENDENCIES_NODE);
        try {
            List results = (List)this.connection.getClient().getChildren().forPath(path);
            return results != null ? new HashSet(results) : Collections.emptySet();
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptySet();
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    @Override
    public void delete(String module, ModuleType type, String target) {
        String path = Paths.build(MODULES_NODE, type.toString(), module, DEPENDENCIES_NODE, target);
        try {
            this.connection.getClient().delete().forPath(path);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }
}

