/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.module.ModuleDependencyRepository;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.module.NoSuchModuleException;
import org.springframework.xd.dirt.module.WritableModuleRegistry;
import org.springframework.xd.dirt.module.support.ModuleDefinitionRepositoryUtils;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.CompositeModuleDefinition;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDefinitions;
import org.springframework.xd.module.ModuleType;

public class ZooKeeperComposedModuleDefinitionRegistry
implements WritableModuleRegistry {
    private final ModuleDependencyRepository moduleDependencyRepository;
    private final ModuleRegistry mainModuleRegistry;
    private final ZooKeeperConnection zooKeeperConnection;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public ZooKeeperComposedModuleDefinitionRegistry(ModuleDependencyRepository moduleDependencyRepository, ModuleRegistry mainModuleRegistry, ZooKeeperConnection zooKeeperConnection) {
        Assert.notNull((Object)moduleDependencyRepository, (String)"moduleDependencyRepository must not be null");
        Assert.notNull((Object)zooKeeperConnection, (String)"zooKeeperConnection must not be null");
        this.moduleDependencyRepository = moduleDependencyRepository;
        this.mainModuleRegistry = mainModuleRegistry;
        this.zooKeeperConnection = zooKeeperConnection;
    }

    @Override
    public boolean delete(ModuleDefinition definition) {
        Assert.notNull((Object)definition, (String)"'definition' cannot be null.");
        if (!definition.isComposed()) {
            return false;
        }
        String path = Paths.build("modules", definition.getType().toString(), definition.getName());
        try {
            this.zooKeeperConnection.getClient().delete().deletingChildrenIfNeeded().forPath(path);
            List children = ((CompositeModuleDefinition)definition).getChildren();
            for (ModuleDefinition child : children) {
                ModuleDefinitionRepositoryUtils.deleteDependencies(this.moduleDependencyRepository, child, this.dependencyKey(definition));
            }
        }
        catch (KeeperException.NoNodeException ignore) {
            return false;
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return true;
    }

    @Override
    public boolean registerNew(ModuleDefinition definition) {
        if (!definition.isComposed()) {
            return false;
        }
        String path = Paths.build("modules", definition.getType().toString(), definition.getName());
        byte[] data = null;
        try {
            data = this.objectMapper.writeValueAsString((Object)definition).getBytes("UTF-8");
            this.zooKeeperConnection.getClient().create().creatingParentsIfNeeded().forPath(path, data);
            List childrenDefinitions = ((CompositeModuleDefinition)definition).getChildren();
            for (ModuleDefinition child : childrenDefinitions) {
                ModuleDefinitionRepositoryUtils.saveDependencies(this.moduleDependencyRepository, child, this.dependencyKey(definition));
            }
        }
        catch (KeeperException.NodeExistsException fallback) {
            try {
                this.zooKeeperConnection.getClient().setData().forPath(path, data);
            }
            catch (Exception e) {
                throw ZooKeeperUtils.wrapThrowable(e);
            }
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return true;
    }

    @Override
    public ModuleDefinition findDefinition(String name, ModuleType type) {
        String path = Paths.build("modules", type.toString(), name);
        try {
            byte[] data = (byte[])this.zooKeeperConnection.getClient().getData().forPath(path);
            if (data.length == 0) {
                return null;
            }
            ModuleDefinition deserializedDefinition = (ModuleDefinition)this.objectMapper.readValue(new String(data, "UTF-8"), ModuleDefinition.class);
            return this.relookup(deserializedDefinition);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
            return null;
        }
    }

    @Override
    public List<ModuleDefinition> findDefinitions(String name) {
        throw new UnsupportedOperationException("Not implemented (but never used)");
    }

    @Override
    public List<ModuleDefinition> findDefinitions(ModuleType type) {
        ArrayList<ModuleDefinition> results = new ArrayList<ModuleDefinition>();
        String path = Paths.build("modules", type.toString());
        try {
            List children = (List)this.zooKeeperConnection.getClient().getChildren().forPath(path);
            for (String child : children) {
                byte[] data = (byte[])this.zooKeeperConnection.getClient().getData().forPath(Paths.build("modules", type.toString(), child));
                if (data == null || data.length <= 0) continue;
                ModuleDefinition composed = this.findDefinition(child, type);
                if (composed != null) {
                    results.add(composed);
                    continue;
                }
                throw new NoSuchModuleException(child, type);
            }
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
        return results;
    }

    @Override
    public List<ModuleDefinition> findDefinitions() {
        ArrayList<ModuleDefinition> results = new ArrayList<ModuleDefinition>();
        for (ModuleType type : ModuleType.values()) {
            results.addAll(this.findDefinitions(type));
        }
        return results;
    }

    private String dependencyKey(ModuleDefinition moduleDefinition) {
        return String.format("module:%s:%s", moduleDefinition.getType(), moduleDefinition.getName());
    }

    private ModuleDefinition relookup(ModuleDefinition definition) {
        if (!definition.isComposed()) {
            return this.mainModuleRegistry.findDefinition(definition.getName(), definition.getType());
        }
        ArrayList<ModuleDefinition> children = new ArrayList<ModuleDefinition>();
        CompositeModuleDefinition composite = (CompositeModuleDefinition)definition;
        for (ModuleDefinition child : composite.getChildren()) {
            children.add(this.relookup(child));
        }
        return ModuleDefinitions.composed((String)composite.getName(), (ModuleType)composite.getType(), (String)composite.getDslDefinition(), children);
    }
}

