/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.store;

import java.io.Serializable;
import java.util.Properties;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.module.ModuleType;

public class ModuleMetadata
implements Comparable<ModuleMetadata> {
    private final Id id;
    private final Properties moduleOptions;
    private final Properties deploymentProperties;
    private final DeploymentUnitStatus.State deploymentStatus;

    public ModuleMetadata(Id id, Properties moduleOptions, Properties deploymentProperties, DeploymentUnitStatus.State deploymentStatus) {
        this.id = id;
        this.moduleOptions = moduleOptions;
        this.deploymentProperties = deploymentProperties;
        this.deploymentStatus = deploymentStatus;
    }

    public String getQualifiedId() {
        return this.id.getFullyQualifiedId();
    }

    public String getName() {
        return this.id.getModuleLabel() + '.' + this.id.getIndex();
    }

    public String getLabel() {
        return this.id.getModuleLabel();
    }

    public String getUnitName() {
        return this.id.getUnitName();
    }

    public ModuleType getModuleType() {
        return this.id.getModuleType();
    }

    public String getContainerId() {
        return this.id.getContainerId();
    }

    public Properties getModuleOptions() {
        return this.moduleOptions;
    }

    public Properties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public DeploymentUnitStatus.State getDeploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public int compareTo(ModuleMetadata other) {
        return this.getQualifiedId().compareTo(other.getQualifiedId());
    }

    public static class Id
    implements Serializable,
    Comparable<Id> {
        private final String containerId;
        private final String unitName;
        private final ModuleType moduleType;
        private final String moduleLabel;
        private final int index;

        public Id(String containerId, String unitName, ModuleType moduleType, String moduleLabel, int index) {
            Assert.hasText((String)containerId);
            Assert.hasText((String)unitName);
            Assert.notNull((Object)moduleType);
            Assert.hasText((String)moduleLabel);
            this.containerId = containerId;
            this.unitName = unitName;
            this.moduleType = moduleType;
            this.moduleLabel = moduleLabel;
            this.index = index;
        }

        public Id(String containerId, String fullyQualifiedId) {
            Assert.hasText((String)containerId);
            Assert.hasText((String)fullyQualifiedId);
            this.containerId = containerId;
            String[] fields = fullyQualifiedId.split("\\.");
            this.unitName = fields[0];
            this.moduleType = ModuleType.valueOf((String)fields[1]);
            this.moduleLabel = fields[2];
            this.index = Integer.valueOf(fields[3]);
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getUnitName() {
            return this.unitName;
        }

        public ModuleType getModuleType() {
            return this.moduleType;
        }

        public String getModuleLabel() {
            return this.moduleLabel;
        }

        public int getIndex() {
            return this.index;
        }

        public String getFullyQualifiedId() {
            return String.format("%s.%s.%s.%d", this.getUnitName(), this.getModuleType(), this.getModuleLabel(), this.getIndex());
        }

        @Override
        public int compareTo(Id that) {
            int c = this.containerId.compareTo(that.containerId);
            if (c == 0) {
                c = this.unitName.compareTo(that.unitName);
            }
            if (c == 0) {
                c = this.moduleType.compareTo((Enum)that.moduleType);
            }
            if (c == 0) {
                c = this.moduleLabel.compareTo(that.moduleLabel);
            }
            if (c == 0) {
                int x = this.index;
                int y = that.index;
                c = x < y ? -1 : (x == y ? 0 : 1);
            }
            return c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id that = (Id)o;
            return this.index == that.index && this.containerId.equals(that.containerId) && this.moduleLabel.equals(that.moduleLabel) && this.moduleType.equals((Object)that.moduleType) && this.unitName.equals(that.unitName);
        }

        public int hashCode() {
            int result = this.containerId != null ? this.containerId.hashCode() : 0;
            result = 31 * result + (this.unitName != null ? this.unitName.hashCode() : 0);
            result = 31 * result + (this.moduleType != null ? this.moduleType.hashCode() : 0);
            result = 31 * result + (this.moduleLabel != null ? this.moduleLabel.hashCode() : 0);
            result = 31 * result + this.index;
            return result;
        }

        public String toString() {
            return "Id{containerId='" + this.containerId + '\'' + ", unitName='" + this.unitName + '\'' + ", moduleType=" + this.moduleType + ", moduleLabel='" + this.moduleLabel + '\'' + ", index=" + this.index + '}';
        }
    }
}

