/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module.jmx;

import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.Assert;

public class ModuleObjectNamingStrategy
implements ObjectNamingStrategy {
    private final Properties objectNameProperties;
    private final String domain;

    public ModuleObjectNamingStrategy(String domain, Properties objectNameProperties) {
        this.domain = domain;
        this.objectNameProperties = objectNameProperties;
        Assert.hasText((String)domain, (String)"domain cannot be null or empty");
        Assert.notNull((Object)objectNameProperties, (String)"moduleProperties cannot be null");
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        ObjectName originalName = ObjectNameManager.getInstance((String)beanKey);
        StringBuilder sb = new StringBuilder();
        sb.append(this.domain).append(":");
        sb.append("module=").append(this.objectNameProperties.get("group")).append(".").append(this.objectNameProperties.getProperty("type")).append(".").append(this.objectNameProperties.getProperty("label")).append(".").append(this.objectNameProperties.getProperty("sequence")).append(",");
        sb.append("component=").append(originalName.getKeyProperty("type")).append(",");
        sb.append("name=").append(originalName.getKeyProperty("name"));
        return ObjectNameManager.getInstance((String)sb.toString());
    }
}

