/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.WritableResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.data.hadoop.configuration.ConfigurationFactoryBean;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.core.RuntimeIOException;
import org.springframework.xd.dirt.module.ExtendedResource;
import org.springframework.xd.dirt.module.ResourceModuleRegistry;
import org.springframework.xd.dirt.module.UploadedModuleDefinition;
import org.springframework.xd.dirt.module.WritableModuleRegistry;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;

public class WritableResourceModuleRegistry
extends ResourceModuleRegistry
implements WritableModuleRegistry,
InitializingBean {
    protected static final byte[] HEX_DIGITS = "0123456789ABCDEF".getBytes();
    protected static final String XD_CONFIG_HOME = "xd.config.home";
    private boolean createDirectoryStructure = true;
    private ConfigurableEnvironment environment;

    public WritableResourceModuleRegistry(String root) {
        super(root);
        this.setRequireHashFiles(true);
    }

    @Override
    public boolean delete(ModuleDefinition definition) {
        try {
            Resource archive = this.getResources(definition.getType().name(), definition.getName(), ".jar").iterator().next();
            if (archive instanceof WritableResource) {
                WritableResource writableResource = (WritableResource)archive;
                WritableResource hashResource = (WritableResource)this.hashResource((Resource)writableResource);
                ExtendedResource.wrap((Resource)hashResource).delete();
                return ExtendedResource.wrap((Resource)writableResource).delete();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception while trying to delete module " + definition, e);
        }
    }

    @Override
    public boolean registerNew(ModuleDefinition definition) {
        if (!(definition instanceof UploadedModuleDefinition)) {
            return false;
        }
        UploadedModuleDefinition uploadedModuleDefinition = (UploadedModuleDefinition)definition;
        try {
            Resource archive = this.getResources(definition.getType().name(), definition.getName(), ".jar").iterator().next();
            if (archive instanceof WritableResource) {
                WritableResource writableResource = (WritableResource)archive;
                Assert.isTrue((!writableResource.exists() ? 1 : 0) != 0, (String)("Could not install " + (Object)((Object)uploadedModuleDefinition) + " at location " + writableResource + " as that file already exists"));
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestInputStream dis = new DigestInputStream(uploadedModuleDefinition.getInputStream(), md);
                FileCopyUtils.copy((InputStream)dis, (OutputStream)writableResource.getOutputStream());
                WritableResource hashResource = (WritableResource)this.hashResource((Resource)writableResource);
                FileCopyUtils.copy((byte[])this.bytesToHex(md.digest()), (OutputStream)hashResource.getOutputStream());
                return true;
            }
            return false;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error trying to save " + (Object)((Object)uploadedModuleDefinition), e);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.root.startsWith("hdfs:")) {
            boolean securityConfigProvided = false;
            String authMethod = "";
            String namenodePrincipal = "";
            String rmManagerPrincipal = "";
            String userPrincipal = "";
            String userKeytab = "";
            if (this.environment != null && this.environment.containsProperty("spring.hadoop.security.authMethod")) {
                securityConfigProvided = true;
                authMethod = this.environment.getProperty("spring.hadoop.security.authMethod");
                namenodePrincipal = this.environment.getProperty("spring.hadoop.security.namenodePrincipal");
                rmManagerPrincipal = this.environment.getProperty("spring.hadoop.security.rmManagerPrincipal");
                userPrincipal = this.environment.getProperty("spring.hadoop.security.userPrincipal");
                userKeytab = this.environment.getProperty("spring.hadoop.security.userKeytab");
            }
            Properties hadoopProps = null;
            if (!securityConfigProvided && this.environment != null) {
                String xdConfigHadoopProps = this.environment.getProperty(XD_CONFIG_HOME) + "hadoop.properties";
                try {
                    hadoopProps = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(xdConfigHadoopProps));
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (hadoopProps != null && (hadoopProps.containsKey("spring.hadoop.security.authMethod") || hadoopProps.containsKey("hadoop.security.authentication"))) {
                    securityConfigProvided = true;
                    authMethod = hadoopProps.getProperty("spring.hadoop.security.authMethod");
                    if (!StringUtils.hasText((String)authMethod)) {
                        authMethod = hadoopProps.getProperty("hadoop.security.authentication");
                    }
                    if (!StringUtils.hasText((String)(namenodePrincipal = hadoopProps.getProperty("spring.hadoop.security.namenodePrincipal")))) {
                        namenodePrincipal = hadoopProps.getProperty("dfs.namenode.kerberos.principal");
                    }
                    if (!StringUtils.hasText((String)(rmManagerPrincipal = hadoopProps.getProperty("spring.hadoop.security.rmManagerPrincipal")))) {
                        rmManagerPrincipal = hadoopProps.getProperty("yarn.resourcemanager.principal");
                    }
                    userPrincipal = hadoopProps.getProperty("spring.hadoop.security.userPrincipal");
                    userKeytab = hadoopProps.getProperty("spring.hadoop.security.userKeytab");
                }
            }
            Properties factoryProps = new Properties();
            if (this.environment != null) {
                for (PropertySource p : this.environment.getPropertySources()) {
                    if (!(p instanceof EnumerablePropertySource)) continue;
                    for (String name : ((EnumerablePropertySource)p).getPropertyNames()) {
                        if (!name.startsWith("spring.hadoop.config.")) continue;
                        factoryProps.put(name.substring(21), this.environment.getProperty(name));
                    }
                }
            }
            ConfigurationFactoryBean configurationFactoryBean = new ConfigurationFactoryBean();
            configurationFactoryBean.setRegisterUrlHandler(true);
            configurationFactoryBean.setFileSystemUri(this.root);
            if (hadoopProps != null) {
                factoryProps.putAll((Map<?, ?>)hadoopProps);
            }
            configurationFactoryBean.setProperties(factoryProps);
            if (securityConfigProvided && "kerberos".equals(authMethod)) {
                configurationFactoryBean.setSecurityMethod(authMethod);
                configurationFactoryBean.setNamenodePrincipal(namenodePrincipal);
                configurationFactoryBean.setRmManagerPrincipal(rmManagerPrincipal);
                configurationFactoryBean.setUserPrincipal(userPrincipal);
                configurationFactoryBean.setUserKeytab(userKeytab);
            }
            configurationFactoryBean.afterPropertiesSet();
            this.resolver = new HdfsResourceLoader(configurationFactoryBean.getObject());
        }
        if (this.createDirectoryStructure) {
            for (ModuleType type : ModuleType.values()) {
                Resource folder = this.getResources(type.name(), "", "").iterator().next();
                if (folder.exists()) continue;
                ExtendedResource.wrap(folder).mkdirs();
            }
        }
    }

    public void setCreateDirectoryStructure(boolean createDirectoryStructure) {
        this.createDirectoryStructure = createDirectoryStructure;
    }

    private byte[] bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_DIGITS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_DIGITS[v & 0xF];
        }
        return hexChars;
    }
}

