/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.RuntimeIOException;
import org.springframework.xd.dirt.module.MD5StalenessCheck;
import org.springframework.xd.dirt.module.StalenessCheck;
import org.springframework.xd.dirt.module.UploadedModuleDefinition;
import org.springframework.xd.dirt.module.WritableModuleRegistry;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.SimpleModuleDefinition;

public class SynchronizingModuleRegistry
implements WritableModuleRegistry {
    private final WritableModuleRegistry remoteRegistry;
    private final WritableModuleRegistry localRegistry;
    private final StalenessCheck staleness = new MD5StalenessCheck();
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public SynchronizingModuleRegistry(WritableModuleRegistry remoteRegistry, WritableModuleRegistry localRegistry) {
        Assert.notNull((Object)remoteRegistry, (String)"remoteRegistry cannot be null");
        Assert.notNull((Object)localRegistry, (String)"localRegistry cannot be null");
        this.remoteRegistry = remoteRegistry;
        this.localRegistry = localRegistry;
    }

    @Override
    public ModuleDefinition findDefinition(String name, ModuleType moduleType) {
        ModuleDefinition remoteDefinition = this.remoteRegistry.findDefinition(name, moduleType);
        if (remoteDefinition == null || remoteDefinition.isComposed()) {
            return remoteDefinition;
        }
        this.copyIfStale((SimpleModuleDefinition)remoteDefinition);
        return this.currentLocalDefinition(remoteDefinition);
    }

    @Override
    public List<ModuleDefinition> findDefinitions(String name) {
        List<ModuleDefinition> remoteDefinitions = this.remoteRegistry.findDefinitions(name);
        return this.refresh(remoteDefinitions);
    }

    @Override
    public List<ModuleDefinition> findDefinitions(ModuleType type) {
        List<ModuleDefinition> remoteDefinitions = this.remoteRegistry.findDefinitions(type);
        return this.refresh(remoteDefinitions);
    }

    @Override
    public List<ModuleDefinition> findDefinitions() {
        List<ModuleDefinition> remoteDefinitions = this.remoteRegistry.findDefinitions();
        return this.refresh(remoteDefinitions);
    }

    private List<ModuleDefinition> refresh(List<ModuleDefinition> remoteDefinitions) {
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>(remoteDefinitions.size());
        for (ModuleDefinition remoteDefinition : remoteDefinitions) {
            if (remoteDefinition.isComposed()) {
                result.add(remoteDefinition);
                continue;
            }
            this.copyIfStale((SimpleModuleDefinition)remoteDefinition);
            result.add(this.currentLocalDefinition(remoteDefinition));
        }
        return result;
    }

    private synchronized void copyIfStale(SimpleModuleDefinition remoteDefinition) {
        ModuleDefinition currentTargetDefinition = this.currentLocalDefinition((ModuleDefinition)remoteDefinition);
        SimpleModuleDefinition targetDefinition = (SimpleModuleDefinition)currentTargetDefinition;
        if (this.staleness.isStale(targetDefinition, remoteDefinition)) {
            InputStream is = null;
            try {
                is = this.resolver.getResource(remoteDefinition.getLocation()).getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeIOException("Error while copying module", e);
            }
            this.localRegistry.delete((ModuleDefinition)remoteDefinition);
            UploadedModuleDefinition definitionToInstall = new UploadedModuleDefinition(remoteDefinition.getName(), remoteDefinition.getType(), is);
            this.localRegistry.registerNew(definitionToInstall);
        }
    }

    private ModuleDefinition currentLocalDefinition(ModuleDefinition remoteDefinition) {
        return this.localRegistry.findDefinition(remoteDefinition.getName(), remoteDefinition.getType());
    }

    @Override
    public boolean delete(ModuleDefinition definition) {
        return this.remoteRegistry.delete(definition);
    }

    @Override
    public boolean registerNew(ModuleDefinition definition) {
        return this.remoteRegistry.registerNew(definition);
    }
}

