/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.core.RuntimeIOException;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDefinitions;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.SimpleModuleDefinition;

public class ResourceModuleRegistry
implements ModuleRegistry {
    public static final String ARCHIVE_AS_FILE_EXTENSION = ".jar";
    public static final String HASH_EXTENSION = ".md5";
    private static final String[] SUFFIXES = new String[]{"", ".jar"};
    private boolean requireHashFiles;
    protected ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    protected String root;

    public ResourceModuleRegistry(String root) {
        this.root = StringUtils.trimTrailingCharacter((String)root, (char)'/');
    }

    protected Resource hashResource(Resource moduleResource) throws IOException {
        String location = moduleResource.getURI().toString() + HASH_EXTENSION;
        return this.sanitize(this.resolver.getResources(location)).iterator().next();
    }

    @Override
    public ModuleDefinition findDefinition(String name, ModuleType moduleType) {
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>();
        try {
            for (String suffix : SUFFIXES) {
                for (Resource resource : this.getResources(moduleType.name(), name, suffix)) {
                    this.collect(resource, result);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("An error occurred trying to locate module '%s:%s'", moduleType, name), e);
        }
        return result.size() == 1 ? (ModuleDefinition)result.iterator().next() : null;
    }

    @Override
    public List<ModuleDefinition> findDefinitions(String name) {
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>();
        try {
            for (String suffix : SUFFIXES) {
                for (Resource resource : this.getResources("*", name, suffix)) {
                    this.collect(resource, result);
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<ModuleDefinition> findDefinitions(ModuleType type) {
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>();
        try {
            for (Resource resource : this.getResources(type.name(), "*", "")) {
                this.collect(resource, result);
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<ModuleDefinition> findDefinitions() {
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>();
        try {
            for (Resource resource : this.getResources("*", "*", "")) {
                this.collect(resource, result);
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        return result;
    }

    protected Iterable<Resource> getResources(String moduleType, String moduleName, String suffix) throws IOException {
        String path = String.format("%s/%s/%s%s", this.root, moduleType, moduleName, suffix);
        Resource[] resources = this.resolver.getResources(path);
        List<Resource> filtered = this.sanitize(resources);
        return filtered;
    }

    private List<Resource> sanitize(Resource[] resources) throws IOException {
        ArrayList<Resource> filtered = new ArrayList<Resource>();
        for (Resource resource : resources) {
            String fileName;
            if (resource instanceof UrlResource && resource.getURL().getProtocol().equals("file") || resource instanceof FileSystemResource) {
                resource = new FileSystemResource(resource.getFile().getCanonicalFile());
            }
            if ((fileName = resource.getFilename()).startsWith(".") || fileName.contains(".") && !fileName.endsWith(ARCHIVE_AS_FILE_EXTENSION) && !fileName.endsWith(HASH_EXTENSION)) continue;
            filtered.add(resource);
        }
        return filtered;
    }

    protected void collect(Resource resource, List<ModuleDefinition> holder) throws IOException {
        SimpleModuleDefinition found;
        if (!resource.exists()) {
            return;
        }
        String path = resource.getURI().toString();
        if (path.endsWith(HASH_EXTENSION)) {
            return;
        }
        if (path.endsWith(ARCHIVE_AS_FILE_EXTENSION) && this.requireHashFiles && !this.hashResource(resource).exists()) {
            return;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int lastSlash = path.lastIndexOf(47);
        int nextToLastSlash = path.lastIndexOf(47, lastSlash - 1);
        String name = path.substring(lastSlash + 1);
        if (name.endsWith(ARCHIVE_AS_FILE_EXTENSION)) {
            name = name.substring(0, name.length() - ARCHIVE_AS_FILE_EXTENSION.length());
        }
        String typeAsString = path.substring(nextToLastSlash + 1, lastSlash);
        ModuleType type = null;
        try {
            type = ModuleType.valueOf((String)typeAsString);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        String locationToUse = resource.getURL().toString();
        if (!locationToUse.endsWith(ARCHIVE_AS_FILE_EXTENSION) && !locationToUse.endsWith("/")) {
            locationToUse = locationToUse + "/";
        }
        if (holder.contains(found = ModuleDefinitions.simple((String)name, (ModuleType)type, (String)locationToUse))) {
            SimpleModuleDefinition other = (SimpleModuleDefinition)holder.get(holder.indexOf(found));
            throw new IllegalStateException(String.format("Duplicate module definitions for '%s:%s' found at '%s' and '%s'", found.getType(), found.getName(), found.getLocation(), other.getLocation()));
        }
        holder.add((ModuleDefinition)found);
    }

    public void setRequireHashFiles(boolean requireHashFiles) {
        this.requireHashFiles = requireHashFiles;
    }
}

