/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.util.Arrays;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.module.ResourceDefinitionException;
import org.springframework.xd.module.ModuleType;

public class NoSuchModuleException
extends ResourceDefinitionException {
    private final String name;
    private final ModuleType[] candidateTypes;

    public NoSuchModuleException(String name, ModuleType ... candidateTypes) {
        super("");
        Assert.hasText((String)name);
        Assert.notEmpty((Object[])candidateTypes);
        this.name = name;
        this.candidateTypes = candidateTypes;
    }

    @Override
    public String getMessage() {
        if (this.candidateTypes.length == 1) {
            return String.format("Could not find module with name '%s' and type '%s'", this.name, this.candidateTypes[0]);
        }
        return String.format("Could not find module with name '%s' and type among %s", this.name, Arrays.asList(this.candidateTypes));
    }

    public String getName() {
        return this.name;
    }

    public ModuleType[] getCandidateTypes() {
        return this.candidateTypes;
    }
}

