/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.core.Module;
import org.springframework.xd.module.core.ModuleFactory;
import org.springframework.xd.module.core.Plugin;

public class ModuleDeployer
implements ApplicationContextAware,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile ApplicationContext context;
    private volatile ApplicationContext globalContext;
    @GuardedBy(value="this")
    private final Map<String, Map<Integer, Module>> deployedModules = new HashMap<String, Map<Integer, Module>>();
    @GuardedBy(value="this")
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final ModuleFactory moduleFactory;

    public ModuleDeployer(ModuleFactory moduleFactory) {
        this.moduleFactory = moduleFactory;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
        ApplicationContext global = null;
        try {
            global = context.getParent().getParent();
        }
        catch (NullPointerException e) {
            this.logger.trace("Exception looking up global application context", (Throwable)e);
        }
        Assert.notNull((Object)global, (String)"Global application context not found");
        this.globalContext = global;
    }

    public synchronized void afterPropertiesSet() {
        if (!this.plugins.isEmpty()) {
            this.plugins.clear();
        }
        this.plugins.addAll(this.context.getParent().getBeansOfType(Plugin.class).values());
        OrderComparator.sort(this.plugins);
    }

    public synchronized Map<String, Map<Integer, Module>> getDeployedModules() {
        HashMap<String, Map<Integer, Module>> map = new HashMap<String, Map<Integer, Module>>();
        for (Map.Entry<String, Map<Integer, Module>> entry : this.deployedModules.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableMap(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public Module createModule(ModuleDescriptor moduleDescriptor, ModuleDeploymentProperties deploymentProperties) {
        return this.moduleFactory.createModule(moduleDescriptor, deploymentProperties);
    }

    public synchronized void deploy(Module module, ModuleDescriptor descriptor) {
        String group = descriptor.getGroup();
        module.setParentContext(this.globalContext);
        this.doDeploy(module);
        this.logger.info("Deployed {}", (Object)module);
        Map<Integer, Module> modules = this.deployedModules.get(group);
        if (modules == null) {
            modules = new HashMap<Integer, Module>();
            this.deployedModules.put(group, modules);
        }
        modules.put(descriptor.getIndex(), module);
    }

    private void doDeploy(Module module) {
        this.preProcessModule(module);
        module.initialize();
        this.postProcessModule(module);
        module.start();
    }

    private void preProcessModule(Module module) {
        for (Plugin plugin : this.getSupportedPlugins(module)) {
            plugin.preProcessModule(module);
        }
    }

    private void postProcessModule(Module module) {
        for (Plugin plugin : this.getSupportedPlugins(module)) {
            plugin.postProcessModule(module);
        }
    }

    public synchronized void undeploy(ModuleDescriptor moduleDescriptor) {
        Introspector.flushCaches();
        String group = moduleDescriptor.getGroup();
        int index = moduleDescriptor.getIndex();
        Map<Integer, Module> modules = this.deployedModules.get(group);
        if (modules != null) {
            Module module = modules.remove(index);
            if (modules.isEmpty()) {
                this.deployedModules.remove(group);
            }
            if (module != null) {
                this.destroyModule(module);
            } else {
                this.logger.debug("Ignoring undeploy - module with index {} from group {} is not deployed", (Object)index, (Object)group);
            }
        } else {
            this.logger.trace("Ignoring undeploy - group not deployed here: {}", (Object)group);
        }
    }

    private void destroyModule(Module module) {
        this.logger.info("Removed {}", (Object)module);
        this.beforeShutdown(module);
        module.stop();
        this.removeModule(module);
        module.destroy();
    }

    private void beforeShutdown(Module module) {
        for (Plugin plugin : this.getSupportedPlugins(module)) {
            try {
                plugin.beforeShutdown(module);
            }
            catch (IllegalStateException e) {
                this.logger.warn("Failed to invoke plugin {} during shutdown: {}", (Object)plugin.getClass().getSimpleName(), (Object)e.getMessage());
                this.logger.debug("Full stack trace", (Throwable)e);
            }
        }
    }

    private void removeModule(Module module) {
        for (Plugin plugin : this.getSupportedPlugins(module)) {
            plugin.removeModule(module);
        }
    }

    private Iterable<Plugin> getSupportedPlugins(Module module) {
        return Iterables.filter(this.plugins, (Predicate)new ModulePluginPredicate(module));
    }

    private class ModulePluginPredicate
    implements Predicate<Plugin> {
        private final Module module;

        private ModulePluginPredicate(Module module) {
            this.module = module;
        }

        public boolean apply(Plugin plugin) {
            return plugin.supports(this.module);
        }
    }
}

