/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.FileCopyUtils;
import org.springframework.xd.dirt.core.RuntimeIOException;
import org.springframework.xd.dirt.module.StalenessCheck;
import org.springframework.xd.module.SimpleModuleDefinition;

public class MD5StalenessCheck
implements StalenessCheck {
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    @Override
    public boolean isStale(SimpleModuleDefinition targetDefinition, SimpleModuleDefinition sourceDefinition) {
        if (targetDefinition == null) {
            return true;
        }
        String md5SourceLocation = sourceDefinition.getLocation() + ".md5";
        String md5TargetLocation = targetDefinition.getLocation() + ".md5";
        String md5Source = this.readHash(md5SourceLocation);
        String md5Target = this.readHash(md5TargetLocation);
        return md5Target == null || md5Source == null || !md5Source.equals(md5Target);
    }

    private String readHash(String hashLocation) {
        Resource resource = this.resolver.getResource(hashLocation);
        if (resource == null || !resource.isReadable()) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)bos);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Exception while trying to read hash at " + hashLocation, e);
        }
        return bos.toString();
    }
}

