/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.ReflectionUtils;

public abstract class ExtendedResource {
    private static final Logger log = LoggerFactory.getLogger(ExtendedResource.class);
    private static Class<?> HDFS_RESOURCE;

    public abstract boolean delete() throws IOException;

    public abstract boolean mkdirs() throws IOException;

    public static ExtendedResource wrap(Resource original) {
        if (original instanceof FileSystemResource) {
            return new FileSystemExtendedResource((FileSystemResource)original);
        }
        if (original.getClass().equals(HDFS_RESOURCE)) {
            return new HdfsExtendedResource(original);
        }
        throw new IllegalArgumentException("Unsupported resource " + original);
    }

    static {
        try {
            HDFS_RESOURCE = Class.forName("org.springframework.data.hadoop.fs.HdfsResource");
        }
        catch (ClassNotFoundException e) {
            log.warn("Spring Data Hadoop is required on the classpath to register modules to HDFS. This feature is disabled.");
        }
    }

    public static class HdfsExtendedResource
    extends ExtendedResource {
        private static final Field PATH_FIELD = ReflectionUtils.findField((Class)ExtendedResource.access$000(), (String)"path");
        private static final Field FS_FIELD;
        private Path path;
        private FileSystem fs;

        HdfsExtendedResource(Resource hdfsResource) {
            this.path = (Path)ReflectionUtils.getField((Field)PATH_FIELD, (Object)hdfsResource);
            this.fs = (FileSystem)ReflectionUtils.getField((Field)FS_FIELD, (Object)hdfsResource);
        }

        @Override
        public boolean delete() throws IOException {
            return this.fs.delete(this.path, true);
        }

        @Override
        public boolean mkdirs() throws IOException {
            return this.fs.mkdirs(this.path);
        }

        static {
            ReflectionUtils.makeAccessible((Field)PATH_FIELD);
            FS_FIELD = ReflectionUtils.findField((Class)HDFS_RESOURCE, (String)"fs");
            ReflectionUtils.makeAccessible((Field)FS_FIELD);
        }
    }

    public static class FileSystemExtendedResource
    extends ExtendedResource {
        private FileSystemResource fsResource;

        FileSystemExtendedResource(FileSystemResource fsResource) {
            this.fsResource = fsResource;
        }

        @Override
        public boolean delete() throws IOException {
            return FileSystemUtils.deleteRecursively((File)this.fsResource.getFile());
        }

        @Override
        public boolean mkdirs() throws IOException {
            return this.fsResource.getFile().mkdirs();
        }
    }
}

