/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.module.WritableModuleRegistry;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleType;

public class DelegatingModuleRegistry
implements WritableModuleRegistry {
    private List<ModuleRegistry> delegates = new ArrayList<ModuleRegistry>();

    public DelegatingModuleRegistry(ModuleRegistry ... delegates) {
        this.setDelegates(delegates);
    }

    public DelegatingModuleRegistry() {
    }

    public void setDelegates(ModuleRegistry ... delegates) {
        for (ModuleRegistry delegate : delegates) {
            this.delegates.add(delegate);
        }
    }

    @Override
    public ModuleDefinition findDefinition(String name, ModuleType moduleType) {
        for (ModuleRegistry delegate : this.delegates) {
            ModuleDefinition result = delegate.findDefinition(name, moduleType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<ModuleDefinition> findDefinitions(String name) {
        HashSet<String> alreadySeen = new HashSet<String>();
        ArrayList<ModuleDefinition> result = new ArrayList<ModuleDefinition>();
        for (ModuleRegistry delegate : this.delegates) {
            List<ModuleDefinition> sub = delegate.findDefinitions(name);
            for (ModuleDefinition definition : sub) {
                if (!alreadySeen.add(this.makeKeyFor(definition))) continue;
                result.add(definition);
            }
        }
        return result;
    }

    public void addDelegate(ModuleRegistry delegate) {
        this.delegates.add(delegate);
    }

    private String makeKeyFor(ModuleDefinition definition) {
        return definition.getType() + "|" + definition.getName();
    }

    @Override
    public List<ModuleDefinition> findDefinitions(ModuleType type) {
        ArrayList<ModuleDefinition> definitions = new ArrayList<ModuleDefinition>();
        HashSet<String> alreadySeen = new HashSet<String>();
        for (ModuleRegistry delegate : this.delegates) {
            for (ModuleDefinition def : delegate.findDefinitions(type)) {
                if (!alreadySeen.add(this.makeKeyFor(def))) continue;
                definitions.add(def);
            }
        }
        return definitions;
    }

    @Override
    public List<ModuleDefinition> findDefinitions() {
        ArrayList<ModuleDefinition> definitions = new ArrayList<ModuleDefinition>();
        HashSet<String> alreadySeen = new HashSet<String>();
        for (ModuleRegistry delegate : this.delegates) {
            for (ModuleDefinition def : delegate.findDefinitions()) {
                if (!alreadySeen.add(this.makeKeyFor(def))) continue;
                definitions.add(def);
            }
        }
        return definitions;
    }

    @Override
    public boolean delete(ModuleDefinition definition) {
        for (ModuleRegistry delegate : this.delegates) {
            WritableModuleRegistry writableModuleRegistry;
            if (!(delegate instanceof WritableModuleRegistry) || !(writableModuleRegistry = (WritableModuleRegistry)delegate).delete(definition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean registerNew(ModuleDefinition definition) {
        for (ModuleRegistry delegate : this.delegates) {
            WritableModuleRegistry writableModuleRegistry;
            if (!(delegate instanceof WritableModuleRegistry) || !(writableModuleRegistry = (WritableModuleRegistry)delegate).registerNew(definition)) continue;
            return true;
        }
        return false;
    }
}

