/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.module;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.xd.dirt.module.SynchronizingModuleRegistry;
import org.springframework.xd.dirt.module.WritableModuleRegistry;
import org.springframework.xd.dirt.module.WritableResourceModuleRegistry;

public class CustomModuleRegistryFactoryBean
implements FactoryBean<WritableModuleRegistry>,
EnvironmentAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(CustomModuleRegistryFactoryBean.class);
    private static final Pattern NO_SYNCHRONIZATION_PATTERN = Pattern.compile("^file:.*");
    private WritableModuleRegistry registry;
    private final String root;
    private ConfigurableEnvironment environment;
    private boolean requiresHashFiles;

    public CustomModuleRegistryFactoryBean(String root) {
        this.root = root;
    }

    public WritableModuleRegistry getObject() throws Exception {
        return this.registry;
    }

    public Class<WritableModuleRegistry> getObjectType() {
        return WritableModuleRegistry.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void afterPropertiesSet() throws Exception {
        Matcher matcher = NO_SYNCHRONIZATION_PATTERN.matcher(this.root);
        if (matcher.matches()) {
            this.registry = new WritableResourceModuleRegistry(this.root);
            ((WritableResourceModuleRegistry)this.registry).setRequireHashFiles(this.requiresHashFiles);
            ((WritableResourceModuleRegistry)this.registry).afterPropertiesSet();
            logger.info("Custom modules will be written directly to {}", (Object)this.root);
        } else {
            String localRoot = "file:" + Files.createTempDirectory("spring-xd-custom-modules", new FileAttribute[0]);
            WritableResourceModuleRegistry local = new WritableResourceModuleRegistry(localRoot);
            local.afterPropertiesSet();
            WritableResourceModuleRegistry remote = new WritableResourceModuleRegistry(this.root);
            remote.setEnvironment((Environment)this.environment);
            remote.afterPropertiesSet();
            this.registry = new SynchronizingModuleRegistry(remote, local);
            logger.info("Custom modules will be written at {} and kept in synch locally at {}", (Object)this.root, (Object)localRoot);
        }
    }

    public void setRequiresHashFiles(boolean requiresHashFiles) {
        this.requiresHashFiles = requiresHashFiles;
    }
}

