/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import org.springframework.xd.dirt.job.dsl.JobReference;
import org.springframework.xd.dirt.job.dsl.Token;
import org.springframework.xd.dirt.job.dsl.TokenKind;
import org.springframework.xd.dirt.stream.dsl.AstNode;

public class Transition
extends AstNode {
    public static final String FAIL = "$FAIL";
    public static final String END = "$END";
    private Token stateNameToken;
    private String stateName;
    private JobReference targetJobReference;

    public Transition(Token stateNameToken, JobReference targetJobReference) {
        super(stateNameToken.startpos, targetJobReference.getEndPos());
        this.stateNameToken = stateNameToken;
        this.targetJobReference = targetJobReference;
        if (stateNameToken.isKind(TokenKind.LITERAL_STRING)) {
            String quotesUsed = stateNameToken.data.substring(0, 1);
            this.stateName = stateNameToken.data.substring(1, stateNameToken.data.length() - 1).replace(quotesUsed + quotesUsed, quotesUsed);
        } else {
            this.stateName = this.stateNameToken.stringValue();
        }
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        StringBuilder s = new StringBuilder();
        s.append("| ");
        s.append(this.stateNameToken.stringValue()).append(" = ").append(this.targetJobReference.getName());
        return s.toString();
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getTargetJobName() {
        return this.targetJobReference.getName();
    }

    public String getStateNameInDSLForm() {
        return this.stateNameToken.data;
    }

    public boolean isSpecialTransition() {
        return this.isFailTransition() || this.isEndTransition();
    }

    public boolean isFailTransition() {
        return this.getStateNameInDSLForm().equals(FAIL);
    }

    public boolean isEndTransition() {
        return this.getStateNameInDSLForm().equals(END);
    }
}

