/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.Collections;
import java.util.List;
import org.springframework.xd.dirt.job.dsl.CheckpointedJobDefinitionException;
import org.springframework.xd.dirt.job.dsl.JobDSLMessage;
import org.springframework.xd.dirt.job.dsl.Token;
import org.springframework.xd.dirt.job.dsl.TokenKind;
import org.springframework.xd.dirt.job.dsl.Tokenizer;

public class Tokens {
    private final String expression;
    private final List<Token> tokenStream;
    private int position = 0;
    private int lastGoodPosition = 0;

    public Tokens(String expression) {
        this.expression = expression;
        this.tokenStream = Collections.unmodifiableList(new Tokenizer(expression).getTokens());
    }

    protected String getExpression() {
        return this.expression;
    }

    protected int decrementPosition() {
        return --this.position;
    }

    protected int position() {
        return this.position;
    }

    public List<Token> getTokenStream() {
        return this.tokenStream;
    }

    protected boolean lookAhead(int distance, TokenKind desiredTokenKind) {
        if (this.position + distance >= this.tokenStream.size()) {
            return false;
        }
        Token t = this.tokenStream.get(this.position + distance);
        return t.kind == desiredTokenKind;
    }

    protected boolean hasNext() {
        return this.position < this.tokenStream.size();
    }

    protected Token peek() {
        return this.hasNext() ? this.tokenStream.get(this.position) : null;
    }

    protected Token peek(int offset) {
        if (this.position + offset >= this.tokenStream.size()) {
            return null;
        }
        return this.tokenStream.get(this.position + offset);
    }

    protected boolean peek(int offset, TokenKind tokenKind) {
        if (this.position + offset >= this.tokenStream.size()) {
            return false;
        }
        Token nextToken = this.tokenStream.get(this.position + offset);
        return nextToken.getKind() == tokenKind;
    }

    protected boolean peek(TokenKind desiredTokenKind) {
        return this.peek(desiredTokenKind, false);
    }

    private boolean peek(TokenKind desiredTokenKind, boolean consumeIfMatched) {
        if (!this.hasNext()) {
            return false;
        }
        Token t = this.peek();
        if (t.kind == desiredTokenKind) {
            if (consumeIfMatched) {
                ++this.position;
            }
            return true;
        }
        return false;
    }

    protected Token next() {
        if (!this.hasNext()) {
            this.raiseException(this.expression.length(), JobDSLMessage.OOD, new Object[0]);
        }
        return this.tokenStream.get(this.position++);
    }

    protected Token eat(TokenKind expectedKind) {
        Token t = this.next();
        if (t == null) {
            this.raiseException(this.expression.length(), JobDSLMessage.OOD, new Object[0]);
        }
        if (t.kind != expectedKind) {
            this.raiseException(t.startpos, JobDSLMessage.NOT_EXPECTED_TOKEN, expectedKind.toString().toLowerCase(), t.getKind().toString().toLowerCase() + (t.data == null ? "" : "(" + t.data + ")"));
        }
        return t;
    }

    protected boolean maybeEat(TokenKind desiredKind) {
        if (this.peek(desiredKind)) {
            this.next();
            return true;
        }
        return false;
    }

    protected boolean isNextAdjacent() {
        if (!this.hasNext()) {
            return false;
        }
        Token last = this.tokenStream.get(this.position - 1);
        Token next = this.tokenStream.get(this.position);
        return next.startpos == last.endpos;
    }

    protected void checkpoint() {
        this.lastGoodPosition = this.position;
    }

    protected void raiseException(int position, JobDSLMessage message, Object ... inserts) {
        throw new CheckpointedJobDefinitionException(this.expression, position, this.position, this.lastGoodPosition, this.tokenStream, message, inserts);
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append(this.tokenStream).append("\n");
        s.append(this.expression).append("\n");
        Token t = this.tokenStream.get(this.position);
        for (i = 0; i < t.startpos; ++i) {
            s.append(" ");
        }
        while (i < t.endpos) {
            s.append("^");
            ++i;
        }
        s.append("\n");
        return s.toString();
    }
}

