/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

public enum TokenKind {
    IDENTIFIER,
    AMPERSAND("&"),
    DOUBLE_PIPE("||"),
    DOUBLE_MINUS("--"),
    OPEN_PAREN("("),
    CLOSE_PAREN(")"),
    EQUALS("="),
    PIPE("|"),
    NEWLINE("\n"),
    SPLIT_OPEN("<"),
    SPLIT_CLOSE(">"),
    LITERAL_STRING;

    char[] tokenChars;
    private boolean hasPayload;

    private TokenKind(String tokenString) {
        this.tokenChars = tokenString.toCharArray();
        this.hasPayload = this.tokenChars.length == 0;
    }

    private TokenKind() {
        this("");
    }

    public String toString() {
        return this.name() + (this.tokenChars.length != 0 ? "(" + new String(this.tokenChars) + ")" : "");
    }

    public boolean hasPayload() {
        return this.hasPayload;
    }

    public int getLength() {
        return this.tokenChars.length;
    }

    public char[] getTokenChars() {
        return this.tokenChars;
    }

    public String getTokenString() {
        return new String(this.tokenChars);
    }
}

