/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import org.springframework.xd.dirt.job.dsl.TokenKind;

public class Token {
    TokenKind kind;
    String data;
    int startpos;
    int endpos;

    Token(TokenKind tokenKind, int startpos, int endpos) {
        this.kind = tokenKind;
        this.startpos = startpos;
        this.endpos = endpos;
    }

    Token(TokenKind tokenKind, char[] tokenData, int pos, int endpos) {
        this(tokenKind, pos, endpos);
        this.data = new String((char[])tokenData.clone());
    }

    public TokenKind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[").append(this.kind.toString());
        if (this.kind.hasPayload()) {
            s.append(":").append(this.data);
        }
        s.append("]");
        s.append("(").append(this.startpos).append(",").append(this.endpos).append(")");
        return s.toString();
    }

    public boolean isIdentifier() {
        return this.kind == TokenKind.IDENTIFIER;
    }

    public String stringValue() {
        return this.data;
    }

    public int hashCode() {
        return this.kind.ordinal() * 37 + (this.startpos + this.endpos) * 37 + (this.kind.hasPayload() ? this.data.hashCode() : 0);
    }

    public boolean equals(Object o) {
        boolean basicmatch;
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        boolean bl = basicmatch = this.kind == token.kind && this.startpos == token.startpos && this.endpos == token.endpos;
        if (!basicmatch) {
            return false;
        }
        return !this.kind.hasPayload() || this.data.equals(token.data);
    }

    public boolean isKind(TokenKind desiredKind) {
        return this.kind == desiredKind;
    }
}

