/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import java.util.Collections;
import java.util.List;
import org.springframework.xd.dirt.job.dsl.JobNode;
import org.springframework.xd.dirt.job.dsl.JobSeries;
import org.springframework.xd.dirt.job.dsl.TokenKind;

public class Split
extends JobSeries {
    private List<JobNode> jobsInParallel;

    public Split(List<JobNode> parallelSequences) {
        super(parallelSequences.get(0).getStartPos(), parallelSequences.get(parallelSequences.size() - 1).getEndPos());
        this.jobsInParallel = Collections.unmodifiableList(parallelSequences);
    }

    @Override
    public String stringify(boolean includePositionInfo) {
        if (this.jobsInParallel.size() == 1) {
            return this.jobsInParallel.get(0).stringify(includePositionInfo);
        }
        StringBuilder s = new StringBuilder(TokenKind.SPLIT_OPEN.getTokenString());
        for (int i = 0; i < this.jobsInParallel.size(); ++i) {
            JobNode jn = this.jobsInParallel.get(i);
            if (i > 0) {
                s.append(" ").append(TokenKind.AMPERSAND.getTokenString()).append(" ");
            }
            s.append(jn.stringify(includePositionInfo));
        }
        s.append(TokenKind.SPLIT_CLOSE.getTokenString());
        return s.toString();
    }

    @Override
    public int getSeriesLength() {
        return this.jobsInParallel.size();
    }

    @Override
    public JobNode getSeriesElement(int index) {
        return this.jobsInParallel.get(index);
    }

    @Override
    public List<JobNode> getSeries() {
        return this.jobsInParallel;
    }

    @Override
    boolean isSplit() {
        return true;
    }

    public String toString() {
        return "[Split:" + this.stringify(true) + "]";
    }
}

