/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Node {
    public static final String METADATAKEY_JOBMODULENAME = "jobModuleName";
    public String id;
    public String name;
    public Map<String, String> metadata;
    public Map<String, String> properties;

    Node() {
    }

    Node(String id, String name) {
        this.id = id;
        this.name = name;
        this.properties = null;
    }

    Node(String id, String name, Map<String, String> metadata, Map<String, String> properties) {
        this.id = id;
        this.name = name;
        this.metadata = metadata;
        this.properties = properties;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Node[id=").append(this.id).append(",name=").append(this.name);
        if (this.properties != null) {
            s.append(",properties=").append(this.properties);
        }
        if (this.metadata != null) {
            s.append(",metadata=").append(this.metadata);
        }
        s.append("]");
        return s.toString();
    }

    @JsonIgnore
    public boolean isStart() {
        return this.name.equals("START");
    }

    @JsonIgnore
    public boolean isEnd() {
        return this.name.equals("END");
    }

    @JsonIgnore
    public boolean isFail() {
        return this.name.equals("FAIL");
    }

    @JsonIgnore
    public boolean isSync() {
        return this.name.equals("SYNC");
    }
}

