/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.job.dsl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Link {
    public String from;
    public String to;
    public Map<String, String> properties = null;

    Link() {
    }

    public Link(int sourceId, int targetId) {
        this.from = Integer.toString(sourceId);
        this.to = Integer.toString(targetId);
    }

    public Link(int sourceId, int targetId, String transitionName) {
        this.from = Integer.toString(sourceId);
        this.to = Integer.toString(targetId);
        this.properties = new HashMap<String, String>();
        this.properties.put("transitionName", transitionName);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Link[from=").append(this.from).append(",to=").append(this.to);
        if (this.properties != null) {
            s.append(",properties=").append(this.properties);
        }
        s.append("]");
        return s.toString();
    }

    public boolean hasTransitionSet() {
        return this.properties != null && this.properties.containsKey("transitionName");
    }

    @JsonIgnore
    public String getTransitionName() {
        return this.properties != null ? this.properties.get("transitionName") : null;
    }

    public void updateFrom(String newFrom) {
        this.from = newFrom;
    }

    public void updateTo(String newTo) {
        this.to = newTo;
    }
}

